/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.projection.UsuarioView;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ClienteRepository
extends JpaRepository<Cliente, Long>,
JpaSpecificationExecutor<Cliente> {
    public static final String ENTITY_NAME = "Cliente";

    @Query(value="SELECT c.usuario.bloqueado FROM Cliente c WHERE c.id = :clienteId")
    public Optional<Boolean> checkCustomerLockIn(@Param(value="clienteId") Long var1);

    public Long countByEmpresaId(Long var1);

    @Query(value="SELECT COUNT(id) FROM Cliente c WHERE c.empresa.id = :empresaId AND DATE(c.dataCadastro) > DATE(:dataInicio) AND DATE(c.dataCadastro) <= DATE(:dataFim)")
    public Optional<Long> countByEmpresaIdAndDate(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3);

    public Long countByTelefoneAndEmpresaId(String var1, Long var2);

    @Query(value="FROM Cliente c WHERE c.usuario.login = :login AND c.empresa.id = :empresaId")
    public List<Cliente> findAccountsByLoginAndEmpresaId(@Param(value="login") String var1, @Param(value="empresaId") Long var2);

    @Query(value="FROM Cliente c WHERE c.telefone = :telefone AND c.empresa.id = :empresaId")
    public List<Cliente> findAccountsByTelefoneAndEmpresaId(@Param(value="telefone") String var1, @Param(value="empresaId") Long var2);

    public Optional<Cliente> findByEmpresaIdAndCodigoDoPdv(Long var1, Long var2);

    public Optional<Cliente> findByUsuarioLoginAndEmpresaId(String var1, Long var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.UsuarioView(c.usuario.id, c.usuario.nome, c.usuario.login, c.usuario.bloqueado) FROM Cliente c WHERE c.id = ?1")
    public Optional<UsuarioView> findByUserCustomerId(Long var1);

    public List<Cliente> findByEmpresaIdOrderByNome(Long var1);

    @Query(value="SELECT c FROM Cliente c WHERE c.empresa.id = :empresaId AND UNACCENT(c.nome) LIKE CONCAT('%', UNACCENT(:nome), '%') ORDER BY c.nome")
    public List<Cliente> findByEmpresaIdAndNome(@Param(value="empresaId") Long var1, @Param(value="nome") String var2);

    @Query(value="FROM Cliente c WHERE NOT EXISTS (FROM Pedido p WHERE DATE(p.dataHoraPedido) >:diasDeDiferenca AND p.cliente.id = c.id) AND c.empresa.id = :empresaId")
    public List<Cliente> findClientesQueNaoCompramA90Dias(@Param(value="diasDeDiferenca") Date var1, @Param(value="empresaId") Long var2);

    @Query(value="FROM Cliente c WHERE c.ativo = FALSE AND DATE(c.dataHoraAtualizacao) <=:diasDeDiferenca ORDER BY c.id")
    public List<Cliente> findContasInativasNosUltimos30Dias(@Param(value="diasDeDiferenca") Date var1);

    @Query(value="FROM Cliente c WHERE c.usuario.login = :login AND c.empresa.id = :empresaId")
    public Optional<Cliente> findByLoginAndEmpresaId(@Param(value="login") String var1, @Param(value="empresaId") Long var2);

    @Deprecated
    @Query(value="FROM Cliente c WHERE c.telefone = :telefone AND c.empresa.id = :empresaId")
    public Optional<Cliente> findByTelefoneAndEmpresaId(@Param(value="telefone") String var1, @Param(value="empresaId") Long var2);

    public Optional<Cliente> findByUsuarioId(Long var1);

    @Query(value="FROM Cliente c WHERE c.ativo = FALSE AND c.empresa.id = :empresaId ORDER BY c.nome")
    public List<Cliente> findClientesInativos(@Param(value="empresaId") Long var1);
}

