/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.enumeration.FormaDeEnvioDoRecado;
import com.escolpi.omni.api.enumeration.SituacaoDoRecado;
import com.escolpi.omni.api.model.entity.Recado;
import com.escolpi.omni.api.util.DateUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class RecadoSpecification
implements Specification<Recado> {
    private static final long serialVersionUID = 2913820643893311970L;
    private SearchCriteria criteria;

    public Predicate toPredicate(Root<Recado> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("formaEnvio")) {
            return builder.equal((Expression)root.get("formaEnvio"), (Object)FormaDeEnvioDoRecado.get((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("situacao")) {
            return builder.equal((Expression)root.get("situacao"), (Object)SituacaoDoRecado.get((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("dataHoraEnvioInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataHoraEnvio"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataHoraEnvioFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataHoraEnvio"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }

    public RecadoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }
}

