/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.model.entity.Pagamento;
import com.escolpi.omni.api.util.DateUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class PagamentoSpecification
implements Specification<Pagamento> {
    private static final long serialVersionUID = 5483729985768407634L;
    private SearchCriteria criteria;

    public PagamentoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<Pagamento> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("pedido").get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("dataHoraPagamentoInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataHoraTransacao"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataHoraPagamentoFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataHoraTransacao"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("nomeCliente")) {
            return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get("pedido").get("cliente").get("nome")}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("status")) {
            return builder.equal((Expression)root.get("status"), this.criteria.getValue());
        }
        return null;
    }
}

