/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.enumeration.DiaDaSemana;
import com.escolpi.omni.api.model.entity.HorarioDeFuncionamento;
import com.escolpi.omni.api.util.DateUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class HorarioDeFuncionamentoSpecification
implements Specification<HorarioDeFuncionamento> {
    private static final long serialVersionUID = 8832919897651241124L;
    private SearchCriteria criteria;

    public HorarioDeFuncionamentoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<HorarioDeFuncionamento> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("diasDaSemana")) {
            List<String> criteriaDiasDaSemana = this.criteria.getValue().toString().contains(",") ? Stream.of(((String)this.criteria.getValue()).split("\\s*,\\s*")).map(String::trim).collect(Collectors.toList()) : Arrays.asList(this.criteria.getValue().toString());
            CriteriaBuilder.In inDiasDaSemana = builder.in((Expression)root.get("diaDaSemana"));
            for (String diaDaSemana : criteriaDiasDaSemana) {
                inDiasDaSemana.value((Object)DiaDaSemana.get((int)Integer.valueOf(diaDaSemana)));
            }
            return inDiasDaSemana;
        }
        if (this.criteria.getKey().equals("horaAbertura")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("horaAbertura"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("horaFechamento")) {
            return builder.lessThanOrEqualTo((Expression)root.get("horaFechamento"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }
}

