/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.enumeration.TipoDeExtratoDeCashback;
import com.escolpi.omni.api.model.entity.ExtratoDeCashback;
import com.escolpi.omni.api.util.DateUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class ExtratoDeCashbackSpecification
implements Specification<ExtratoDeCashback> {
    private static final long serialVersionUID = 2984142077912360759L;
    private SearchCriteria criteria;

    public ExtratoDeCashbackSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<ExtratoDeCashback> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("cashbackId")) {
            return builder.equal((Expression)root.get("cashback").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("tipoDeLancamento")) {
            return builder.equal((Expression)root.get("tipoDeLancamento"), (Object)TipoDeExtratoDeCashback.valueOf((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("dataHoraLancamentoInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataHoraDoLancamento"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataHoraLancamentoFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataHoraDoLancamento"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        return null;
    }
}

