/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.dto.CatalogoDoRodizio;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="produtos")
@SequenceGenerator(name="produtos_gen", sequenceName="produtos_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Produto
implements Serializable {
    private static final long serialVersionUID = 4866569022774982267L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="produtos_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoria_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa"})
    private CategoriaDoProduto categoria;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoria_rodizio_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa"})
    private CategoriaDoProduto categoriaDoRodizio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @Column(name="codigo_atos")
    private String codigoAtos;
    @Column(name="codigo_atos_broto")
    private String codigoAtosBroto;
    @Column(name="codigo_atos_medio")
    private String codigoAtosBrotoMedio;
    @Column(name="codigo_atos_grande")
    private String codigoAtosBrotoGrande;
    @Column(name="codigo_atos_gigante")
    private String codigoAtosBrotoGigante;
    @Column(name="nome")
    private String nome;
    @Column(name="descricao")
    private String descricao;
    @Column(name="valor", length=8, precision=2)
    private BigDecimal valor;
    @Column(name="valor_tam_broto", length=8, precision=2)
    private BigDecimal valorTamanhoBroto;
    @Column(name="valor_tam_medio", length=8, precision=2)
    private BigDecimal valorTamanhoMedio;
    @Column(name="valor_tam_grande", length=8, precision=2)
    private BigDecimal valorTamanhoGrande;
    @Column(name="valor_tam_gigante", length=8, precision=2)
    private BigDecimal valorTamanhoGigante;
    @Column(name="valor_desconto")
    private BigDecimal valorDesconto;
    @Column(name="label_tam_broto")
    private String labelTamanhoBroto;
    @Column(name="label_tam_medio")
    private String labelTamanhoMedio;
    @Column(name="label_tam_grande")
    private String labelTamanhoGrande;
    @Column(name="label_tam_gigante")
    private String labelTamanhoGigante;
    @Column(name="ind_falta")
    private Boolean emFalta;
    @Column(name="ind_venda_por_fracao")
    private Boolean vendaPorFracao;
    @Column(name="ind_venda_por_tamanho")
    private Boolean vendaPorTamanho;
    @Column(name="caminho_foto")
    private String caminhoFoto;
    @Column(name="dthr_ultima_atualizacao")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraUltimaAtualizacao;
    @Column(name="excluido")
    private Boolean excluido;
    @Column(name="peso_medio")
    private Double pesoMedio;
    @Column(name="ind_foto_externa")
    private Boolean fotoExterna;
    @Column(name="disponibilidades")
    private String disponibilidades;
    @Column(name="estoque")
    private BigDecimal estoque;
    @Column(name="ind_estoque_ilimitado")
    private Boolean estoqueIlimitado;
    @Column(name="limite_selecao_tam_broto")
    private Integer limiteSelecaoTamanhoBroto;
    @Column(name="limite_selecao_tam_medio")
    private Integer limiteSelecaoTamanhoMedio;
    @Column(name="limite_selecao_tam_grande")
    private Integer limiteSelecaoTamanhoGrande;
    @Column(name="limite_selecao_tam_gigante")
    private Integer limiteSelecaoTamanhoGigante;
    @Column(name="ind_exibe_tela_inicial")
    private Boolean exibeNaTelaInicial;
    @Column(name="ind_venda_por_atacado")
    private Boolean vendaPorAtacado;
    @Column(name="qtd_min_valor_venda_por_atacado")
    private Integer qtdeMinVendaPorAtacado;
    @Column(name="valor_atacado", length=8, precision=2)
    private BigDecimal valorAtacado;
    @Column(name="ind_rodizio")
    private Boolean rodizio;
    @Column(name="ind_disponivel_rodizio")
    private Boolean disponivelParaORodizio;
    @Column(name="produtos_rodizio")
    private String produtosDoRodizio;
    @Column(name="valor_meio_rodizio")
    private BigDecimal valorMeioRodizio;
    @Column(name="ind_opcionais_por_produto")
    private Boolean opcionaisPorProduto;
    @Column(name="ind_apenas_opcionais_por_produto")
    private Boolean apenasOpcionaisPorProduto;
    @Column(name="altura")
    private Double altura;
    @Column(name="largura")
    private Double largura;
    @Column(name="profundidade")
    private Double profundidade;
    @Column(name="peso")
    private Double peso;
    @Column(name="valor_prazo")
    private BigDecimal valorAPrazo;
    @Transient
    private String foto;
    @Transient
    private boolean editarFoto;
    @Transient
    private String miniatura;
    @Transient
    private Set<CatalogoDoRodizio> catalogoDoRodizio;

    public Produto() {
    }

    public Produto(Long id, String nome, BigDecimal estoque, Boolean estoqueIlimitado) {
        this.id = id;
        this.nome = nome;
        this.estoque = estoque;
        this.estoqueIlimitado = estoqueIlimitado;
    }

    public Produto(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CategoriaDoProduto getCategoria() {
        return this.categoria;
    }

    public void setCategoria(CategoriaDoProduto categoria) {
        this.categoria = categoria;
    }

    public CategoriaDoProduto getCategoriaDoRodizio() {
        return this.categoriaDoRodizio;
    }

    public void setCategoriaDoRodizio(CategoriaDoProduto categoriaDoRodizio) {
        this.categoriaDoRodizio = categoriaDoRodizio;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public String getCodigoAtos() {
        return this.codigoAtos;
    }

    public void setCodigoAtos(String codigoAtos) {
        this.codigoAtos = codigoAtos;
    }

    public String getCodigoAtosBroto() {
        return this.codigoAtosBroto;
    }

    public void setCodigoAtosBroto(String codigoAtosBroto) {
        this.codigoAtosBroto = codigoAtosBroto;
    }

    public String getCodigoAtosBrotoMedio() {
        return this.codigoAtosBrotoMedio;
    }

    public void setCodigoAtosBrotoMedio(String codigoAtosBrotoMedio) {
        this.codigoAtosBrotoMedio = codigoAtosBrotoMedio;
    }

    public String getCodigoAtosBrotoGrande() {
        return this.codigoAtosBrotoGrande;
    }

    public void setCodigoAtosBrotoGrande(String codigoAtosBrotoGrande) {
        this.codigoAtosBrotoGrande = codigoAtosBrotoGrande;
    }

    public String getCodigoAtosBrotoGigante() {
        return this.codigoAtosBrotoGigante;
    }

    public void setCodigoAtosBrotoGigante(String codigoAtosBrotoGigante) {
        this.codigoAtosBrotoGigante = codigoAtosBrotoGigante;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public BigDecimal getValorTamanhoBroto() {
        return this.valorTamanhoBroto;
    }

    public void setValorTamanhoBroto(BigDecimal valorTamanhoBroto) {
        this.valorTamanhoBroto = valorTamanhoBroto;
    }

    public BigDecimal getValorTamanhoMedio() {
        return this.valorTamanhoMedio;
    }

    public void setValorTamanhoMedio(BigDecimal valorTamanhoMedio) {
        this.valorTamanhoMedio = valorTamanhoMedio;
    }

    public BigDecimal getValorTamanhoGrande() {
        return this.valorTamanhoGrande;
    }

    public void setValorTamanhoGrande(BigDecimal valorTamanhoGrande) {
        this.valorTamanhoGrande = valorTamanhoGrande;
    }

    public BigDecimal getValorTamanhoGigante() {
        return this.valorTamanhoGigante;
    }

    public void setValorTamanhoGigante(BigDecimal valorTamanhoGigante) {
        this.valorTamanhoGigante = valorTamanhoGigante;
    }

    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public String getLabelTamanhoBroto() {
        return this.labelTamanhoBroto;
    }

    public void setLabelTamanhoBroto(String labelTamanhoBroto) {
        this.labelTamanhoBroto = labelTamanhoBroto;
    }

    public String getLabelTamanhoMedio() {
        return this.labelTamanhoMedio;
    }

    public void setLabelTamanhoMedio(String labelTamanhoMedio) {
        this.labelTamanhoMedio = labelTamanhoMedio;
    }

    public String getLabelTamanhoGrande() {
        return this.labelTamanhoGrande;
    }

    public void setLabelTamanhoGrande(String labelTamanhoGrande) {
        this.labelTamanhoGrande = labelTamanhoGrande;
    }

    public String getLabelTamanhoGigante() {
        return this.labelTamanhoGigante;
    }

    public void setLabelTamanhoGigante(String labelTamanhoGigante) {
        this.labelTamanhoGigante = labelTamanhoGigante;
    }

    public Boolean getEmFalta() {
        return this.emFalta;
    }

    public void setEmFalta(Boolean emFalta) {
        this.emFalta = emFalta;
    }

    public Boolean getVendaPorFracao() {
        return this.vendaPorFracao;
    }

    public void setVendaPorFracao(Boolean vendaPorFracao) {
        this.vendaPorFracao = vendaPorFracao;
    }

    public Boolean getVendaPorTamanho() {
        if (this.vendaPorTamanho == null) {
            this.vendaPorTamanho = false;
        }
        return this.vendaPorTamanho;
    }

    public void setVendaPorTamanho(Boolean vendaPorTamanho) {
        this.vendaPorTamanho = vendaPorTamanho;
    }

    public String getCaminhoFoto() {
        return this.caminhoFoto;
    }

    public void setCaminhoFoto(String caminhoFoto) {
        this.caminhoFoto = caminhoFoto;
    }

    public Date getDataHoraUltimaAtualizacao() {
        return this.dataHoraUltimaAtualizacao;
    }

    public void setDataHoraUltimaAtualizacao(Date dataHoraUltimaAtualizacao) {
        this.dataHoraUltimaAtualizacao = dataHoraUltimaAtualizacao;
    }

    public Boolean getExcluido() {
        if (this.excluido == null) {
            this.excluido = false;
        }
        return this.excluido;
    }

    public void setExcluido(Boolean excluido) {
        this.excluido = excluido;
    }

    public Double getPesoMedio() {
        return this.pesoMedio;
    }

    public void setPesoMedio(Double pesoMedio) {
        this.pesoMedio = pesoMedio;
    }

    public Boolean getFotoExterna() {
        return this.fotoExterna;
    }

    public void setFotoExterna(Boolean fotoExterna) {
        this.fotoExterna = fotoExterna;
    }

    public String getDisponibilidades() {
        return this.disponibilidades;
    }

    public void setDisponibilidades(String disponibilidades) {
        this.disponibilidades = disponibilidades;
    }

    public BigDecimal getEstoque() {
        return this.estoque;
    }

    public void setEstoque(BigDecimal estoque) {
        this.estoque = estoque;
    }

    public Boolean getEstoqueIlimitado() {
        return this.estoqueIlimitado;
    }

    public void setEstoqueIlimitado(Boolean estoqueIlimitado) {
        this.estoqueIlimitado = estoqueIlimitado;
    }

    public Integer getLimiteSelecaoTamanhoBroto() {
        return this.limiteSelecaoTamanhoBroto;
    }

    public void setLimiteSelecaoTamanhoBroto(Integer limiteSelecaoTamanhoBroto) {
        this.limiteSelecaoTamanhoBroto = limiteSelecaoTamanhoBroto;
    }

    public Integer getLimiteSelecaoTamanhoMedio() {
        return this.limiteSelecaoTamanhoMedio;
    }

    public void setLimiteSelecaoTamanhoMedio(Integer limiteSelecaoTamanhoMedio) {
        this.limiteSelecaoTamanhoMedio = limiteSelecaoTamanhoMedio;
    }

    public Integer getLimiteSelecaoTamanhoGrande() {
        return this.limiteSelecaoTamanhoGrande;
    }

    public void setLimiteSelecaoTamanhoGrande(Integer limiteSelecaoTamanhoGrande) {
        this.limiteSelecaoTamanhoGrande = limiteSelecaoTamanhoGrande;
    }

    public Integer getLimiteSelecaoTamanhoGigante() {
        return this.limiteSelecaoTamanhoGigante;
    }

    public void setLimiteSelecaoTamanhoGigante(Integer limiteSelecaoTamanhoGigante) {
        this.limiteSelecaoTamanhoGigante = limiteSelecaoTamanhoGigante;
    }

    public Boolean getExibeNaTelaInicial() {
        return this.exibeNaTelaInicial;
    }

    public void setExibeNaTelaInicial(Boolean exibeNaTelaInicial) {
        this.exibeNaTelaInicial = exibeNaTelaInicial;
    }

    public Boolean getVendaPorAtacado() {
        return this.vendaPorAtacado;
    }

    public void setVendaPorAtacado(Boolean vendaPorAtacado) {
        this.vendaPorAtacado = vendaPorAtacado;
    }

    public Integer getQtdeMinVendaPorAtacado() {
        return this.qtdeMinVendaPorAtacado;
    }

    public void setQtdeMinVendaPorAtacado(Integer qtdeMinVendaPorAtacado) {
        this.qtdeMinVendaPorAtacado = qtdeMinVendaPorAtacado;
    }

    public BigDecimal getValorAtacado() {
        return this.valorAtacado;
    }

    public void setValorAtacado(BigDecimal valorAtacado) {
        this.valorAtacado = valorAtacado;
    }

    public Boolean getRodizio() {
        return this.rodizio;
    }

    public void setRodizio(Boolean rodizio) {
        this.rodizio = rodizio;
    }

    public Boolean getDisponivelParaORodizio() {
        return this.disponivelParaORodizio;
    }

    public void setDisponivelParaORodizio(Boolean disponivelParaORodizio) {
        this.disponivelParaORodizio = disponivelParaORodizio;
    }

    public String getProdutosDoRodizio() {
        return this.produtosDoRodizio;
    }

    public void setProdutosDoRodizio(String produtosDoRodizio) {
        this.produtosDoRodizio = produtosDoRodizio;
    }

    public BigDecimal getValorMeioRodizio() {
        return this.valorMeioRodizio;
    }

    public void setValorMeioRodizio(BigDecimal valorMeioRodizio) {
        this.valorMeioRodizio = valorMeioRodizio;
    }

    public Boolean getOpcionaisPorProduto() {
        return this.opcionaisPorProduto;
    }

    public void setOpcionaisPorProduto(Boolean opcionaisPorProduto) {
        this.opcionaisPorProduto = opcionaisPorProduto;
    }

    public Boolean getApenasOpcionaisPorProduto() {
        return this.apenasOpcionaisPorProduto;
    }

    public void setApenasOpcionaisPorProduto(Boolean apenasOpcionaisPorProduto) {
        this.apenasOpcionaisPorProduto = apenasOpcionaisPorProduto;
    }

    public Double getAltura() {
        return this.altura;
    }

    public void setAltura(Double altura) {
        this.altura = altura;
    }

    public Double getLargura() {
        return this.largura;
    }

    public void setLargura(Double largura) {
        this.largura = largura;
    }

    public Double getProfundidade() {
        return this.profundidade;
    }

    public void setProfundidade(Double profundidade) {
        this.profundidade = profundidade;
    }

    public Double getPeso() {
        return this.peso;
    }

    public void setPeso(Double peso) {
        this.peso = peso;
    }

    public BigDecimal getValorAPrazo() {
        return this.valorAPrazo;
    }

    public void setValorAPrazo(BigDecimal valorAPrazo) {
        this.valorAPrazo = valorAPrazo;
    }

    public String getFoto() {
        return this.foto;
    }

    public void setFoto(String foto) {
        this.foto = foto;
    }

    public boolean isEditarFoto() {
        return this.editarFoto;
    }

    public void setEditarFoto(boolean editarFoto) {
        this.editarFoto = editarFoto;
    }

    public String getMiniatura() {
        return this.miniatura;
    }

    public void setMiniatura(String miniatura) {
        this.miniatura = miniatura;
    }

    public Set<CatalogoDoRodizio> getCatalogoDoRodizio() {
        return this.catalogoDoRodizio;
    }

    public void setCatalogoDoRodizio(Set<CatalogoDoRodizio> catalogoDoRodizio) {
        this.catalogoDoRodizio = catalogoDoRodizio;
    }
}

