/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.enumeration.DiaDaSemana;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.util.NullUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="empresas_horarios_funcionamento")
@SequenceGenerator(name="empresas_horarios_funcionamento_gen", sequenceName="empresas_horarios_funcionamento_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HorarioDeFuncionamento
implements Serializable {
    private static final long serialVersionUID = 5438509249523354645L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="empresas_horarios_funcionamento_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="dia_semana")
    private DiaDaSemana diaDaSemana;
    @Temporal(value=TemporalType.TIME)
    @Column(name="hr_abertura")
    private Date horaAbertura;
    @Temporal(value=TemporalType.TIME)
    @Column(name="hr_fechamento")
    private Date horaFechamento;
    @Column(name="ind_abre_no_dia")
    private Boolean abreNoDia;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public DiaDaSemana getDiaDaSemana() {
        return this.diaDaSemana;
    }

    public void setDiaDaSemana(DiaDaSemana diaDaSemana) {
        this.diaDaSemana = diaDaSemana;
    }

    public Date getHoraAbertura() {
        return this.horaAbertura;
    }

    public void setHoraAbertura(Date horaAbertura) {
        this.horaAbertura = horaAbertura;
    }

    public Date getHoraFechamento() {
        return this.horaFechamento;
    }

    public void setHoraFechamento(Date horaFechamento) {
        this.horaFechamento = horaFechamento;
    }

    public String getDiaDaSemanaPorExtenso() {
        if (NullUtil.isNotNull((Object)this.diaDaSemana)) {
            return this.diaDaSemana.getDescricao();
        }
        return null;
    }

    public Boolean getAbreNoDia() {
        return this.abreNoDia;
    }

    public void setAbreNoDia(Boolean abreNoDia) {
        this.abreNoDia = abreNoDia;
    }
}

