/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.util;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.util.NullUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MaskFormatter;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    public static String formatarPrimeiraLetraMaiuscula(String str) {
        String valor = "";
        if (!StringUtils.isEmpty((Object)str)) {
            valor = Character.toUpperCase(str.charAt(0)) + str.substring(1);
            valor = valor.substring(0, 1) + valor.substring(1, valor.length()).toLowerCase();
        }
        return valor;
    }

    public static boolean isBlank(String valor) {
        return valor == null || valor.trim() == "" || valor.trim().length() == 0 || valor.trim() == "null" || valor.trim() == "undefined";
    }

    public static boolean isNotBlank(String valor) {
        return valor != null && valor.length() > 0;
    }

    public static boolean isValidPattern(String value, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(value);
        return matcher.find();
    }

    public static String formatar(String pattern, Object valor) throws ParseException {
        MaskFormatter mascara = new MaskFormatter(pattern);
        mascara.setValueContainsLiteralCharacters(false);
        try {
            return mascara.valueToString(valor);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatarCPF(String valor) {
        try {
            return StringUtil.formatar((String)"###.###.###-##", (Object)valor);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatarCNPJ(String valor) {
        try {
            return StringUtil.formatar((String)"##.###.###/####-##", (Object)valor);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatarCPFouCNPJ(String valor) {
        switch (valor.length()) {
            case 11: {
                return StringUtil.formatarCPF((String)valor);
            }
            case 14: {
                return StringUtil.formatarCNPJ((String)valor);
            }
        }
        return "";
    }

    public static String formatarCEP(String valor) {
        try {
            valor = StringUtil.removerMascara((String)valor);
            return StringUtil.formatar((String)"##.###-###", (Object)valor);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatarTelefone(String valor) {
        try {
            if (valor.length() == 11) {
                return StringUtil.formatar((String)"(##) #####-####", (Object)valor);
            }
            return StringUtil.formatar((String)"(##) ####-####", (Object)valor);
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static String formatarTelefoneComMascara(String valor) {
        try {
            String phoneEnd = valor.substring(valor.length() - 4, valor.length());
            if (valor.length() == 11) {
                return StringUtil.formatar((String)"(xx) xxxxx-####", (Object)phoneEnd);
            }
            return StringUtil.formatar((String)"(xx) xxxx-####", (Object)phoneEnd);
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static String formatarData(Date data) {
        if (data == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        return sdf.format(data);
    }

    public static String formatarDecimal(Double valor) {
        NumberFormat nf = NumberFormat.getInstance(new Locale("pt", "BR"));
        return nf.format(valor);
    }

    public static String formatarMoeda(Double valor) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("pt", "BR"));
        return nf.format(valor);
    }

    public static String formatDecimal(String value) {
        if (value == null) {
            return "";
        }
        return value.replaceAll(",", ".");
    }

    public static String removerAcentos(String valor) {
        if (StringUtil.isBlank((String)valor)) {
            return "";
        }
        valor = Normalizer.normalize(valor, Normalizer.Form.NFD);
        valor = valor.replaceAll("[^\\p{ASCII}]", "");
        return valor;
    }

    public static String gerarToken(String str) throws ApiException {
        if (StringUtil.isBlank((String)str)) {
            return null;
        }
        byte[] hash = StringUtil.gerarHash((String)str, (String)"MD5");
        str = StringUtil.getStringHexa((byte[])hash);
        return str;
    }

    public static void trimAll(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (NullUtil.isNotNull((Object)obj)) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                if (!field.getType().isAssignableFrom(String.class) || !NullUtil.isNotNull((Object)field.get(obj))) continue;
                String value = (String)field.get(obj);
                field.set(obj, value.trim());
                field.setAccessible(accessible);
            }
        }
    }

    public static byte[] gerarHash(String frase, String algoritimo) throws ApiException {
        if (StringUtil.isNotBlank((String)frase)) {
            try {
                MessageDigest md = MessageDigest.getInstance(algoritimo);
                md.update(frase.getBytes("UTF-8"));
                return md.digest();
            }
            catch (Exception e) {
                throw new ApiException("Erro ao gerar hash: " + e.getMessage());
            }
        }
        return null;
    }

    public static String getStringHexa(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int parteAlta = (bytes[i] >> 4 & 0xF) << 4;
            int parteBaixa = bytes[i] & 0xF;
            if (parteAlta == 0) {
                builder.append('0');
            }
            builder.append(Integer.toHexString(parteAlta | parteBaixa));
        }
        return builder.toString();
    }

    public static String capitalizar(String texto) {
        ArrayList<String> preposicoes = new ArrayList<String>();
        preposicoes.addAll(Arrays.asList("o", "a", "os", "as", "de", "do", "da", "em", "dos", "das"));
        try {
            String[] palavras = texto.split(" ");
            if (palavras.length > 0) {
                StringBuilder novoValor = new StringBuilder();
                for (int i = 0; i < palavras.length; ++i) {
                    int index = i;
                    palavras[i] = palavras[i].toLowerCase();
                    Boolean ePreposicao = !preposicoes.stream().anyMatch(preposicao -> preposicao.equals(palavras[index]));
                    if (ePreposicao.booleanValue()) {
                        novoValor.append(StringUtils.capitalize((String)palavras[i])).append(" ");
                        continue;
                    }
                    novoValor.append(palavras[i]).append(" ");
                }
                return novoValor.toString().trim();
            }
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public static Matcher compilarFiltro(String search) {
        search = StringUtil.removerAcentos((String)search);
        Pattern pattern = Pattern.compile("([\\w]+?)(:|<|>)([\\w, ]+)(@@)*");
        return pattern.matcher(search + "@@");
    }

    public static String criptografar(String valor, String algoritmo) throws ApiException {
        return StringUtil.getStringHexa((byte[])StringUtil.gerarHash((String)valor, (String)algoritmo));
    }

    @Deprecated
    public static String criptografarSenha(String valor) {
        if (StringUtil.isBlank((String)valor)) {
            return null;
        }
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.encode((CharSequence)valor);
    }

    public static String codificarBase64(Number codigo) throws Exception {
        try {
            if (codigo != null) {
                return Base64.getEncoder().encodeToString(codigo.toString().getBytes("UTF-8"));
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("Erro ao codificar para base 64: ".concat(e.getMessage()));
        }
    }

    public static String decodificarBase64(String codigo) throws Exception {
        if (StringUtil.isNotBlank((String)codigo)) {
            return new String(Base64.getDecoder().decode(codigo));
        }
        return null;
    }

    public static String gerarSenha() {
        String[] caracteres = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "x", "w", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "W", "Y", "Z"};
        String senha = "";
        for (int i = 0; i < 8; ++i) {
            int j = (int)(Math.random() * (double)caracteres.length);
            senha = senha + caracteres[j];
        }
        return senha;
    }

    public static boolean isBooleanString(String value) {
        if (StringUtil.isBlank((String)value)) {
            return false;
        }
        return value.equals("true") || value.contentEquals("false");
    }

    public static boolean isNumericString(String valor) {
        if (valor == null) {
            return false;
        }
        return valor.matches("([0-9])*");
    }

    public static String obterExtensao(String nomeArquivo) {
        if (StringUtil.isNotBlank((String)nomeArquivo)) {
            return nomeArquivo.substring(nomeArquivo.lastIndexOf(46), nomeArquivo.length()).toLowerCase();
        }
        return null;
    }

    public static String obterNomeArquivo(String nomeArquivo) {
        if (StringUtil.isNotBlank((String)nomeArquivo)) {
            return nomeArquivo.substring(0, nomeArquivo.lastIndexOf(46));
        }
        return null;
    }

    public static String removerUltimoCaractere(String valor, String caractere) {
        if (StringUtil.isNotBlank((String)valor) && StringUtil.isNotBlank((String)caractere)) {
            return valor.substring(0, valor.lastIndexOf(caractere));
        }
        return null;
    }

    public static String minificarString(String valor) {
        if (StringUtil.isNotBlank((String)valor)) {
            valor = valor.replaceAll(" ", "");
            valor = valor.toLowerCase();
            valor = StringUtil.removerAcentos((String)valor);
            return valor;
        }
        return null;
    }

    public static String formatarFlag(boolean flag, String whenTrue, String whenFalse) {
        if (whenTrue != null && whenFalse != null) {
            if (flag) {
                return whenTrue;
            }
            return whenFalse;
        }
        return "N/A";
    }

    public static String truncarValor(String valor, Integer limite) {
        if (valor.length() >= limite) {
            valor = valor.substring(0, limite) + "...";
        }
        return valor;
    }

    public static String removerMascara(String valor) {
        if (StringUtil.isBlank((String)valor)) {
            return null;
        }
        if (StringUtil.emailValido((String)valor)) {
            return valor;
        }
        if (StringUtil.telefoneValido((String)valor)) {
            valor = valor.replace(" ", "");
        }
        return valor.replaceAll("[^a-z\u00e0-\u00faA-Z\u00c0-\u00da0-9 ]", "").replaceAll(" ", "");
    }

    public static void removerMascaras(Object obj) throws ApiException {
        if (NullUtil.isNotEmpty((Object[])obj.getClass().getDeclaredFields())) {
            Arrays.asList(obj.getClass().getDeclaredFields()).stream().filter(field -> !Modifier.isStatic(field.getModifiers()) && field.getType().isAssignableFrom(String.class)).forEach(field -> {
                try {
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    if (NullUtil.isNotNull((Object)field.get(obj))) {
                        field.set(obj, StringUtil.removerMascara((String)field.get(obj).toString()));
                    }
                    field.setAccessible(accessible);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    try {
                        throw new ApiException("erro.api.padrao", new String[]{e.getMessage()});
                    }
                    catch (ApiException apiEx) {
                        apiEx.printStackTrace();
                    }
                }
            });
        }
    }

    public static String removeAllSpaces(String valor) {
        if (StringUtil.isBlank((String)valor)) {
            return valor;
        }
        return valor.replaceAll("\\s+", " ");
    }

    public static boolean emailValido(String email) {
        if (StringUtil.isBlank((String)email)) {
            return false;
        }
        Matcher matcher = Domains.Regex.EMAIL_VALIDATION.matcher(email);
        return matcher.find();
    }

    public static String encodeToIso88591(String str) {
        if (StringUtil.isBlank((String)str)) {
            return "";
        }
        Charset utf8Charset = Charset.forName("UTF-8");
        Charset iso88591Charset = Charset.forName("ISO-8859-1");
        ByteBuffer inputBuffer = ByteBuffer.wrap(str.getBytes());
        CharBuffer data = utf8Charset.decode(inputBuffer);
        ByteBuffer outputBuffer = iso88591Charset.encode(data);
        byte[] encoded = outputBuffer.array();
        return new String(encoded);
    }

    public static boolean telefoneValido(String telefone) {
        if (StringUtil.isBlank((String)telefone)) {
            return false;
        }
        Matcher matcher = Domains.Regex.TELEPHONE_VALIDATION.matcher(telefone);
        return matcher.find();
    }

    public static String getFirstName(String nomeCompleto) {
        if (nomeCompleto.contains(" ")) {
            return nomeCompleto.split(" ")[0];
        }
        return nomeCompleto;
    }
}

