/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.util;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.enumeration.DiaDaSemana;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Locale;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    public static Integer calcularDiferencasEmAnos(java.util.Date dataInicio, java.util.Date dataFim) {
        Calendar calInicio = Calendar.getInstance();
        calInicio.setTime(dataInicio);
        Calendar calFim = Calendar.getInstance();
        calFim.setTime(dataFim);
        int anoInicial = calInicio.get(1);
        int anoFim = calFim.get(1);
        return anoInicial - anoFim;
    }

    public static java.util.Date getDateFromLastIntervalOnDays(java.util.Date currentDate, int days) {
        LocalDate localDate = currentDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return DateUtil.parseLocalDateToDate((LocalDate)localDate.minusDays(days));
    }

    public static final Long calcularDiferencaEntreDatasEmDias(java.util.Date dataInicio, java.util.Date dataFim) {
        LocalDateTime inicio = DateUtil.parseLocalDateTime((java.util.Date)dataInicio);
        LocalDateTime fim = DateUtil.parseLocalDateTime((java.util.Date)dataFim);
        return inicio.until(fim, ChronoUnit.DAYS);
    }

    public static Enum<DiaDaSemana> obterDiaDaSemanaCorrente() {
        return DiaDaSemana.get((int)Calendar.getInstance().get(7));
    }

    public static java.util.Date obterDiferencaEmDias(LocalDate data, int intervaloEmDias) {
        return java.util.Date.from(data.minus(Period.ofDays(intervaloEmDias)).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static final Long calcularDiferencaEntreDatasEmHoras(java.util.Date dataInicio, java.util.Date dataFim) {
        LocalDateTime inicio = DateUtil.parseLocalDateTime((java.util.Date)dataInicio);
        LocalDateTime fim = DateUtil.parseLocalDateTime((java.util.Date)dataFim);
        return inicio.until(fim, ChronoUnit.HOURS);
    }

    public static final Long calcularDiferencaEntreDatasEmMinutos(java.util.Date dataInicio, java.util.Date dataFim) {
        LocalDateTime inicio = DateUtil.parseLocalDateTime((java.util.Date)dataInicio);
        LocalDateTime fim = DateUtil.parseLocalDateTime((java.util.Date)dataFim);
        return inicio.until(fim, ChronoUnit.MINUTES);
    }

    public static final Integer calcularDiferencasEmMeses(java.util.Date dataInicio, java.util.Date dataFim) {
        if (dataFim.before(dataInicio)) {
            throw new IllegalArgumentException("Datas invalidas para contagem de meses");
        }
        Calendar calInicio = Calendar.getInstance();
        calInicio.setTime(dataInicio);
        Calendar calFim = Calendar.getInstance();
        calFim.setTime(dataFim);
        int mesesInicial = calInicio.get(2) + calInicio.get(1) * 12;
        int mesesFinal = calFim.get(2) + calFim.get(1) * 12;
        return mesesFinal - mesesInicial;
    }

    public static final Integer contarDiferencaEmDias30Dias(java.util.Date dataInicio, java.util.Date dataFim) {
        int meses = DateUtil.calcularDiferencasEmMeses((java.util.Date)dataInicio, (java.util.Date)dataFim);
        if (meses == 1) {
            return DateUtil.contarDiferencaDentroMesEmDias30Dias((java.util.Date)dataInicio, (java.util.Date)dataFim);
        }
        Integer diasMesInicio = DateUtil.contarDiferencaDentroMesEmDias30Dias((java.util.Date)dataInicio, (java.util.Date)DateUtil.ultimoDiaMes((java.util.Date)dataInicio));
        Integer diasMesFim = DateUtil.contarDiferencaDentroMesEmDias30Dias((java.util.Date)DateUtil.primeiroDiaMes((java.util.Date)dataFim), (java.util.Date)dataFim);
        Integer diasIntervalo = 0;
        if (meses >= 2) {
            diasIntervalo = (meses - 2) * 30;
        }
        return diasMesInicio + diasIntervalo + diasMesFim;
    }

    private static final Integer contarDiferencaDentroMesEmDias30Dias(java.util.Date dataInicio, java.util.Date dataFim) {
        Integer dias = DateUtil.contarDiferencaEmDias((java.util.Date)dataInicio, (java.util.Date)dataFim);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dataFim);
        int ultimoDia = cal.getActualMaximum(5);
        if (dias < ultimoDia && cal.get(5) != ultimoDia) {
            return dias;
        }
        if (cal.get(2) == 1) {
            return dias + (30 - ultimoDia);
        }
        return dias - (ultimoDia - 30);
    }

    public static final Integer contarDiferencaEmDias(java.util.Date dataInicio, java.util.Date dataFim) {
        if (dataFim.before(dataInicio)) {
            throw new IllegalArgumentException("Datas invalidas para contagem de dias");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(DateUtil.clearDateTime((java.util.Date)dataInicio));
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(DateUtil.clearDateTime((java.util.Date)dataFim));
        int count = 0;
        while (!DateUtil.isMesmaData((java.util.Date)cal1.getTime(), (java.util.Date)cal2.getTime()).booleanValue()) {
            cal1.add(5, 1);
            ++count;
        }
        return count + 1;
    }

    public static final Integer contarDiferencaEmHoras(java.util.Date dataInicio, java.util.Date dataFim) {
        if (dataFim.before(dataInicio)) {
            throw new IllegalArgumentException("Datas invalidas para contagem de horas.");
        }
        Calendar calInicial = Calendar.getInstance();
        calInicial.setTime(dataInicio);
        Calendar calFinal = Calendar.getInstance();
        calFinal.setTime(dataFim);
        Long minutos = (calFinal.getTimeInMillis() - calInicial.getTimeInMillis()) / 60000L;
        Long horas = minutos / 60L;
        return horas.intValue();
    }

    public static Boolean isMesmaData(java.util.Date data1, java.util.Date data2) {
        return DateUtil.formatDefaultDate((java.util.Date)data1).equals(DateUtil.formatDefaultDate((java.util.Date)data2));
    }

    public static java.util.Date ultimoDiaMes(java.util.Date data) {
        Calendar atual = Calendar.getInstance();
        atual.setTime(DateUtil.clearDateTime((java.util.Date)data));
        int ultimoDia = atual.getActualMaximum(5);
        atual.set(5, ultimoDia);
        return atual.getTime();
    }

    public static java.util.Date ultimoDiaMes(int mesReferencia) {
        Calendar atual = Calendar.getInstance();
        atual.setTime(new java.util.Date());
        atual.set(2, mesReferencia - 1);
        return DateUtil.ultimoDiaMes((java.util.Date)atual.getTime());
    }

    public static Integer ano(java.util.Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(1);
    }

    public static Integer mes(java.util.Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(2) + 1;
    }

    public static java.util.Date dataSemHorario(java.util.Date data) {
        try {
            if (data != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                return sdf.parse(sdf.format(data));
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static java.util.Date dataApenasComHorario(java.util.Date data, boolean comSegundos) {
        try {
            if (data != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(comSegundos ? "HH:mm:ss" : "HH:mm");
                return sdf.parse(sdf.format(data));
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static java.util.Date primeiroDiaMes(java.util.Date data) {
        Calendar atual = Calendar.getInstance();
        atual.setTime(DateUtil.clearDateTime((java.util.Date)data));
        atual.set(5, 1);
        return atual.getTime();
    }

    public static java.util.Date primeiroDiaMes(int mesReferencia) {
        Calendar atual = Calendar.getInstance();
        atual.setTime(new java.util.Date());
        atual.set(2, mesReferencia - 1);
        return DateUtil.primeiroDiaMes((java.util.Date)atual.getTime());
    }

    public static java.util.Date primeiroDiaDoMesAno(Integer mes, Integer ano) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)DateUtil.montarData((Integer)1, (Integer)mes, (Integer)ano)));
        return cal.getTime();
    }

    public static Boolean isPassado(java.util.Date data) {
        return DateUtil.clearDateTime((java.util.Date)new java.util.Date()).after(DateUtil.clearDateTime((java.util.Date)data));
    }

    public static final java.util.Date clearDateTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(date);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(5, calTemp.get(5));
        cal.set(1, calTemp.get(1));
        cal.set(2, calTemp.get(2));
        return cal.getTime();
    }

    public static final java.util.Date maxDateTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static final String formatDefaultDate(java.util.Date date) {
        return DateUtil.format((String)"dd/MM/yyyy", (java.util.Date)date);
    }

    public static final String format(String pattern, java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sd = new SimpleDateFormat(pattern);
        return sd.format(date);
    }

    public static java.util.Date primeiroDiaAno(Integer ano) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)new java.util.Date()));
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(1, ano);
        return cal.getTime();
    }

    public static java.util.Date ultimoDiaAno(Integer ano) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)new java.util.Date()));
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(1, ano);
        return cal.getTime();
    }

    public static java.util.Date ultimoDiaDoMesAno(Integer mes, Integer ano) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)DateUtil.montarData((Integer)1, (Integer)mes, (Integer)ano)));
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static java.util.Date ultimoDiaUtilDoMesAno(Integer mes, Integer ano) {
        java.util.Date ultimoDiaMes = DateUtil.ultimoDiaDoMesAno((Integer)mes, (Integer)ano);
        if (DateUtil.isDiaUtil((java.util.Date)ultimoDiaMes).booleanValue()) {
            return ultimoDiaMes;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)ultimoDiaMes));
        do {
            cal.add(5, -1);
        } while (!DateUtil.isDiaUtil((java.util.Date)cal.getTime()).booleanValue());
        return cal.getTime();
    }

    public static java.util.Date ultimoDiaUtil(java.util.Date ultimoDiaMes) {
        if (DateUtil.isDiaUtil((java.util.Date)(ultimoDiaMes = DateUtil.ultimoDiaMes((java.util.Date)ultimoDiaMes))).booleanValue()) {
            return ultimoDiaMes;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)ultimoDiaMes));
        do {
            cal.add(5, -1);
        } while (!DateUtil.isDiaUtil((java.util.Date)cal.getTime()).booleanValue());
        return cal.getTime();
    }

    public static java.util.Date montarData(Integer dia, Integer mes, Integer ano) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)new java.util.Date()));
        cal.set(2, mes - 1);
        cal.set(5, dia);
        cal.set(1, ano);
        return cal.getTime();
    }

    public static java.util.Date montarData(Integer dia, Integer mes, Integer ano, Integer horas, Integer minutos, Integer segundos) {
        Calendar cal = Calendar.getInstance();
        if (NullUtil.isNotNullOrZero((Number)dia)) {
            cal.set(5, dia);
        }
        if (NullUtil.isNotNullOrZero((Number)mes)) {
            cal.set(2, mes - 1);
        }
        if (NullUtil.isNotNullOrZero((Number)ano)) {
            cal.set(1, ano);
        }
        if (NullUtil.isNotNull((Object)horas)) {
            cal.set(11, horas);
        }
        if (NullUtil.isNotNull((Object)minutos)) {
            cal.set(12, minutos);
        }
        if (NullUtil.isNotNull((Object)segundos)) {
            cal.set(13, segundos);
        }
        return cal.getTime();
    }

    public static Boolean isDiaUtil(java.util.Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        int diaDaSemana = cal.get(7);
        if (diaDaSemana >= 2 && diaDaSemana <= 6) {
            return true;
        }
        return false;
    }

    public static java.util.Date primeiroDiaUtilApartirDaData(java.util.Date data) {
        if (DateUtil.isDiaUtil((java.util.Date)data).booleanValue()) {
            return data;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)data));
        do {
            cal.add(5, 1);
        } while (!DateUtil.isDiaUtil((java.util.Date)cal.getTime()).booleanValue());
        return cal.getTime();
    }

    public static java.util.Date primeiroDiaUtilAteData(java.util.Date data) {
        if (DateUtil.isDiaUtil((java.util.Date)data).booleanValue()) {
            return data;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)data));
        do {
            cal.add(5, -1);
        } while (!DateUtil.isDiaUtil((java.util.Date)cal.getTime()).booleanValue());
        return cal.getTime();
    }

    public static java.util.Date adicionaDias(java.util.Date data, Integer dias) {
        Integer incremento = null;
        if (dias.equals(0)) {
            return data;
        }
        incremento = dias > 0 ? Integer.valueOf(1) : Integer.valueOf(-1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)data));
        cal.add(5, incremento);
        return cal.getTime();
    }

    public static java.util.Date adicionaDiasUteis(java.util.Date data, Integer dias) {
        Integer incremento = null;
        if (dias.equals(0)) {
            return data;
        }
        incremento = dias > 0 ? Integer.valueOf(1) : Integer.valueOf(-1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)data));
        Integer contador = 0;
        while (!contador.equals(dias)) {
            cal.add(5, incremento);
            if (!DateUtil.isDiaUtil((java.util.Date)cal.getTime()).booleanValue()) continue;
            contador = contador + incremento;
        }
        return cal.getTime();
    }

    public static java.util.Date addDay(java.util.Date date, int days) {
        return DateUtil.parseDate((LocalDate)DateUtil.parseLocalDate((java.util.Date)date).plusDays(days));
    }

    public static java.util.Date addMinutes(java.util.Date date, int minutes) {
        return DateUtil.parseDate((LocalDateTime)DateUtil.parseLocalDateTime((java.util.Date)date).plusMinutes(minutes));
    }

    public static java.util.Date addMonths(java.util.Date date, int months) {
        return DateUtil.parseDate((LocalDate)DateUtil.parseLocalDate((java.util.Date)date).plusMonths(months));
    }

    public static Integer dia(java.util.Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(5);
    }

    public static Boolean isMesAtual(java.util.Date data) {
        java.util.Date comparar = DateUtil.clearDateTime((java.util.Date)data);
        java.util.Date agora = new java.util.Date();
        if (DateUtil.primeiroDiaMes((java.util.Date)agora).compareTo(comparar) <= 0 && DateUtil.ultimoDiaMes((java.util.Date)agora).compareTo(comparar) >= 0) {
            return true;
        }
        return false;
    }

    public static String descricaoMes(Integer mes) {
        if (mes == null) {
            return "";
        }
        if (mes < 0 || mes > 12) {
            throw new IllegalArgumentException("Mes informado [" + mes + "] \u00e9 inv\u00e1lido.");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new java.util.Date());
        cal.set(5, 1);
        cal.set(2, mes - 1);
        return DateUtil.format((String)"MMMMM", (java.util.Date)cal.getTime());
    }

    public static java.util.Date retrocederDias(java.util.Date data, Integer dias) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)data));
        cal.add(5, -dias.intValue());
        return cal.getTime();
    }

    public static java.util.Date retrocederMeses(java.util.Date data, Integer meses) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.clearDateTime((java.util.Date)data));
        cal.add(2, -meses.intValue());
        return cal.getTime();
    }

    public static Boolean isMes(Integer mes, Integer ano, java.util.Date dataComparar) {
        return (mes + "" + ano).equals(DateUtil.mes((java.util.Date)dataComparar) + "" + DateUtil.ano((java.util.Date)dataComparar));
    }

    public static final Integer calcularDiferencaProporcionalDiasEm30Dias(java.util.Date dataFim, Integer diasCargaHoraria) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dataFim);
        diasCargaHoraria = cal.get(2) == 1 ? Integer.valueOf(diasCargaHoraria + (30 - cal.getActualMaximum(5))) : Integer.valueOf(diasCargaHoraria - (cal.getActualMaximum(5) - 30));
        return diasCargaHoraria;
    }

    public static Integer calcularDiferencaPeriodo(java.util.Date dataFinal, java.util.Date dataInicial) throws ParseException {
        int anos = DateUtil.calcularDiferencasEmAnos((java.util.Date)dataInicial, (java.util.Date)dataFinal);
        if (anos == 0) {
            int meses = DateUtil.calcularDiferencasEmMeses((java.util.Date)dataInicial, (java.util.Date)dataFinal);
            if (meses == 0) {
                return DateUtil.contarDiferencaDentroMesEmDias30Dias((java.util.Date)dataInicial, (java.util.Date)dataFinal);
            }
            return meses;
        }
        return anos;
    }

    public static java.util.Date criarHora(Integer horas, Integer minutos, Integer segundos) {
        LocalTime time = NullUtil.isNotNullOrZero((Number)segundos) ? LocalTime.of(horas, minutos, segundos) : LocalTime.of(horas, minutos);
        return java.util.Date.from(time.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Boolean isMesmoMes(java.util.Date dataMes, java.util.Date dataComparar) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(dataMes);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(dataComparar);
        return cal2.get(2) == cal1.get(2) && cal2.get(1) == cal1.get(1);
    }

    public static final java.util.Date format(String pattern, String data) {
        try {
            if (StringUtil.isBlank((String)data)) {
                return null;
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return new java.util.Date(format.parse(data).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String concatenarPeriodo(java.util.Date dataInicial, java.util.Date dataFinal) {
        StringBuilder periodo = new StringBuilder();
        periodo.append(DateUtil.format((String)"dd/MM/yyyy 'a' ", (java.util.Date)dataInicial));
        periodo.append(DateUtil.format((String)"dd/MM/yyyy", (java.util.Date)dataFinal));
        return periodo.toString();
    }

    public static Boolean pertenceAoPeriodo(java.util.Date data, java.util.Date dataInicial, java.util.Date dataFinal) {
        if (((data = DateUtil.dataSemHorario((java.util.Date)data)).equals(dataInicial) || data.after(dataInicial)) && (data.equals(dataFinal) || data.before(dataFinal))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean pertenceAoPeriodoComHoras(java.util.Date data, java.util.Date dataInicial, java.util.Date dataFinal) {
        if ((data.equals(dataInicial) || data.after(dataInicial)) && (data.equals(dataFinal) || data.before(dataFinal))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean periodosIguais(java.util.Date data, java.util.Date dataInicial, java.util.Date dataFinal) {
        if (data.equals(dataInicial) && data.equals(dataFinal)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Calendar parseCalendar(java.util.Date data) {
        Calendar cal = Calendar.getInstance(new Locale("pt-BR"));
        cal.setTime(data);
        return cal;
    }

    public static java.util.Date parseDate(LocalDate date) {
        return java.util.Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date parseDate(LocalDateTime date) {
        return java.util.Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalTime parseLocalTime(java.util.Date data) {
        Calendar cal = DateUtil.parseCalendar((java.util.Date)data);
        return LocalTime.of(cal.get(11), cal.get(12), cal.get(13));
    }

    public static LocalDate parseLocalDate(java.util.Date date) {
        Calendar cal = DateUtil.parseCalendar((java.util.Date)date);
        return LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static java.util.Date parseLocalDateToDate(LocalDate localDate) {
        return Date.valueOf(localDate);
    }

    public static final java.util.Date parseStringToDate(String pattern, String data) {
        try {
            if (!StringUtils.hasText((String)pattern)) {
                return null;
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return new java.util.Date(format.parse(data).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static LocalDateTime parseLocalDateTime(java.util.Date data) {
        Calendar cal = DateUtil.parseCalendar((java.util.Date)data);
        return LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static java.util.Date parseMillisecondsToDate(long milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(milliseconds);
        return cal.getTime();
    }

    public static boolean eHorarioDaMadrugada(java.util.Date hora) {
        LocalTime horario = DateUtil.parseLocalTime((java.util.Date)hora);
        return horario.equals(Domains.HORA_INICIO_MADRUGADA) || horario.isAfter(Domains.HORA_INICIO_MADRUGADA) && horario.isBefore(Domains.HORA_FIM_MADRUGADA);
    }

    public static DiaDaSemana diaDaSemana() {
        int diaDaSemana = Calendar.getInstance().get(7);
        if (diaDaSemana == 1) {
            return DiaDaSemana.DOMINGO;
        }
        if (diaDaSemana == 2) {
            return DiaDaSemana.SEGUNDA_FEIRA;
        }
        if (diaDaSemana == 3) {
            return DiaDaSemana.TERCA_FEIRA;
        }
        if (diaDaSemana == 4) {
            return DiaDaSemana.QUARTA_FEIRA;
        }
        if (diaDaSemana == 5) {
            return DiaDaSemana.QUINTA_FEIRA;
        }
        if (diaDaSemana == 6) {
            return DiaDaSemana.SEXTA_FEIRA;
        }
        if (diaDaSemana == 7) {
            return DiaDaSemana.SABADO;
        }
        return DiaDaSemana.TODOS_OS_DIAS;
    }

    public static java.util.Date setTimeByTimezone(Calendar calendar, FusoHorario fusoHorario) {
        calendar.add(11, fusoHorario.getDiferencaHoras());
        return calendar.getTime();
    }

    public static java.util.Date setTimeByTimezone(FusoHorario fusoHorario) {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.setTimeByTimezone((Calendar)calendar, (FusoHorario)fusoHorario);
    }
}

