/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.TipoToken;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Token;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.repository.TokenRepository;
import com.escolpi.omni.api.repository.UsuarioRepository;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.NullUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TokenService
implements BaseCrudService<Token, Long> {
    @Autowired
    private TokenRepository repository;
    @Autowired
    private UsuarioRepository userRepository;
    @Autowired
    private EmpresaService companyService;

    @Transactional
    public void save(Token fcmToken) throws ApiException {
        if (NullUtil.isNull((Object)fcmToken.getTipo())) {
            fcmToken.setTipo(TipoToken.APP);
        }
        if (this.isTokenValid(fcmToken).booleanValue()) {
            if (!this.companyService.companyExists(fcmToken.getEmpresa().getId())) {
                return;
            }
            if (NullUtil.isNotNull((Object)fcmToken.getUsuario())) {
                Usuario usuarioEncontrado = (Usuario)this.userRepository.findByCustomerLoginAndEmpresaId(fcmToken.getUsuario().getLogin(), fcmToken.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", fcmToken.getUsuario().getId().toString()}));
                Token edicao = this.repository.findTopByUsuarioIdAndTipoOrderByIdDesc(usuarioEncontrado.getId(), fcmToken.getTipo()).orElse(null);
                if (NullUtil.isNotNull((Object)edicao)) {
                    if (!edicao.getToken().equals(fcmToken.getToken())) {
                        edicao.setToken(fcmToken.getToken());
                        this.repository.save((Object)edicao);
                    }
                } else {
                    edicao = this.repository.findTopByTokenAndEmpresaIdAndTipo(fcmToken.getToken(), fcmToken.getEmpresa().getId(), fcmToken.getTipo()).orElse(null);
                    if (NullUtil.isNull((Object)edicao)) {
                        fcmToken.setUsuarioId(fcmToken.getUsuario().getId());
                        this.repository.save((Object)fcmToken);
                    } else if (NullUtil.isNotNull((Object)fcmToken.getUsuario())) {
                        edicao.setUsuario(fcmToken.getUsuario());
                        edicao.setUsuarioId(fcmToken.getUsuario().getId());
                        this.repository.save((Object)edicao);
                    } else {
                        this.repository.save((Object)fcmToken);
                    }
                }
            } else {
                Token edicao = this.repository.findTopByTokenAndEmpresaIdAndTipo(fcmToken.getToken(), fcmToken.getEmpresa().getId(), fcmToken.getTipo()).orElse(null);
                if (NullUtil.isNull((Object)edicao)) {
                    this.repository.save((Object)fcmToken);
                } else {
                    this.repository.save((Object)edicao);
                }
            }
        }
    }

    public void validate(Token fcmToken) throws ApiException {
        if (NullUtil.isNull((Object)fcmToken)) {
            throw new ApiException("msg.erro.001", new String[]{"Fcm Token"});
        }
        if (NullUtil.isNull((Object)fcmToken.getToken()) || fcmToken.getToken().equals("null") || fcmToken.getToken().equals("(null)")) {
            throw new ApiException("msg.erro.001", new String[]{"Token"});
        }
        if (NullUtil.isNull((Object)fcmToken.getTipo())) {
            throw new ApiException("msg.erro.001", new String[]{"Tipo"});
        }
        if (NullUtil.isNull((Object)fcmToken.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
    }

    public void delete(Long id) throws ApiException {
    }

    public Page<Token> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        return null;
    }

    public List<Token> findAll(Long empresaId) throws ApiException {
        return null;
    }

    public Token findById(Long id) throws ApiException {
        return null;
    }

    private Boolean isTokenValid(Token fcmToken) {
        if (NullUtil.isNull((Object)fcmToken)) {
            return false;
        }
        if (NullUtil.isNull((Object)fcmToken.getToken()) || fcmToken.getToken().equals("null") || fcmToken.getToken().equals("(null)")) {
            return false;
        }
        if (NullUtil.isNull((Object)fcmToken.getTipo())) {
            return false;
        }
        if (NullUtil.isNull((Object)fcmToken.getEmpresa())) {
            return false;
        }
        return true;
    }
}

