/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.TarifaDeEntregaPorRaio;
import com.escolpi.omni.api.model.entity.TarifacaoDeEntrega;
import com.escolpi.omni.api.model.entity.dto.Option;
import com.escolpi.omni.api.model.specification.builder.TarifacaoDeEntregaSpecificationBuilder;
import com.escolpi.omni.api.repository.BairroNaoAtendidoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.MunicipioAtendidoRepository;
import com.escolpi.omni.api.repository.TarifaDeEntregaPorRaioRepository;
import com.escolpi.omni.api.repository.TarifacaoDeEntregaRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TarifacaoDeEntregaService
implements BaseCrudService<TarifacaoDeEntrega, Long> {
    @Autowired
    EmpresaRepository empresaRepository;
    @Autowired
    private TarifacaoDeEntregaRepository repository;
    @Autowired
    private TarifaDeEntregaPorRaioRepository tarifacaoDeEntregaPorRaioRepository;
    @Autowired
    MunicipioAtendidoRepository municipioAtendidoRepository;
    @Autowired
    private BairroNaoAtendidoRepository bairroNaoAtendidoRepository;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            this.repository.deleteById((Object)id);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            throw new ApiException("msg.erro.048", new String[]{"Tarifa\u00e7\u00e3o de Entrega", "Pedido"});
        }
    }

    public Page<TarifacaoDeEntrega> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        TarifacaoDeEntregaSpecificationBuilder builder = new TarifacaoDeEntregaSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<TarifacaoDeEntrega> findAll(Long empresaId) throws ApiException {
        return this.repository.findByEmpresaId(empresaId);
    }

    public TarifacaoDeEntrega findById(Long id) throws ApiException {
        return (TarifacaoDeEntrega)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Tarifa\u00e7\u00e3o de Entrega", id.toString()}));
    }

    public TarifacaoDeEntrega findById(Long id, Long empresaId) throws ApiException {
        TarifacaoDeEntrega deliveryFee = (TarifacaoDeEntrega)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Tarifa\u00e7\u00e3o de Entrega", id.toString()}));
        if (!deliveryFee.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculada", new String[]{Entidade.TARIFACAO_DE_ENTREGA.getDescricao()});
        }
        return deliveryFee;
    }

    public TarifaDeEntregaPorRaio getDeliveryFeeByDistance(Long companyId, Integer distance) {
        return this.tarifacaoDeEntregaPorRaioRepository.findByDistance(companyId, distance);
    }

    public List<Option> listCitiesByCompanyId(Long empresaId) throws ApiException {
        ArrayList<Option> options = new ArrayList<Option>();
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        options.add(new Option(empresa.getMunicipio().getMunicipioFormatado(), empresa.getMunicipio().getId().toString()));
        this.municipioAtendidoRepository.findByEmpresaIdOrderByMunicipioNome(empresaId).forEach(municipioAtendido -> options.add(new Option(municipioAtendido.getMunicipio().getMunicipioFormatado(), municipioAtendido.getMunicipio().getId().toString())));
        return options;
    }

    @Transactional
    public void save(TarifacaoDeEntrega tarifacao) throws ApiException {
        this.validate(tarifacao);
        tarifacao.setBairro(tarifacao.getBairro().trim());
        if (NullUtil.isNotNullOrZero((Number)tarifacao.getId())) {
            TarifacaoDeEntrega edicao = this.findById(tarifacao.getId());
            edicao.setBairro(tarifacao.getBairro());
            edicao.setMunicipio(tarifacao.getMunicipio());
            edicao.setValor(tarifacao.getValor());
            this.repository.save((Object)edicao);
            return;
        }
        this.repository.save((Object)tarifacao);
    }

    public void validate(TarifacaoDeEntrega tarifacao) throws ApiException {
        if (NullUtil.isNull((Object)tarifacao)) {
            throw new ApiException("msg.erro.001", new String[]{"Tarifa\u00e7\u00e3o de Entrega"});
        }
        if (StringUtil.isBlank((String)tarifacao.getBairro())) {
            throw new ApiException("msg.erro.001", new String[]{"Bairro"});
        }
        if (NullUtil.isNull((Object)tarifacao.getMunicipio())) {
            throw new ApiException("msg.erro.001", new String[]{"Munic\u00edpio"});
        }
        if (NullUtil.isNotNullOrZero((Number)tarifacao.getId()) ? this.repository.countByIdNotAndMunicipioIdAndEmpresaIdAndBairroIgnoreCase(tarifacao.getId(), tarifacao.getMunicipio().getId(), tarifacao.getEmpresa().getId(), tarifacao.getBairro()) > 1L : this.repository.countByEmpresaIdAndMunicipioIdAndBairroIgnoreCase(tarifacao.getEmpresa().getId(), tarifacao.getMunicipio().getId(), tarifacao.getBairro()) > 0L) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Tarifa\u00e7\u00e3o de Entrega"});
        }
        if (this.bairroNaoAtendidoRepository.countByEmpresaAndBairroAndMunicipio(tarifacao.getEmpresa().getId(), tarifacao.getMunicipio().getId(), tarifacao.getBairro()) > 0L) {
            throw new ApiException("msg.erro.171", new String[]{tarifacao.getBairro(), "bairros n\u00e3o atendidos"});
        }
        if (NullUtil.isNull((Object)tarifacao.getValor())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor"});
        }
    }
}

