/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import br.com.uol.pagseguro.api.transaction.search.TransactionDetail;
import com.escolpi.omni.api.enumeration.StatusDaTransacao;
import com.escolpi.omni.api.enumeration.TipoPagamento;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Pagamento;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.specification.builder.PagamentoSpecificationBuilder;
import com.escolpi.omni.api.repository.CartaoDoClienteRepository;
import com.escolpi.omni.api.repository.PagamentoRepository;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PagamentoService {
    @Autowired
    private CartaoDoClienteRepository cartaoRepository;
    @Autowired
    private PagamentoRepository repository;
    @Autowired
    @Lazy
    private PedidoService pedidoService;

    public Page<Pagamento> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        PagamentoSpecificationBuilder builder = new PagamentoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("dataHoraTransacao"), (String)"desc");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable);
        if (results.hasContent()) {
            results.getContent().forEach(payment -> payment.getPedido().setTotalDoPedido(this.pedidoService.calculateTotalOrderValue(payment.getPedido())));
        }
        return results;
    }

    public Pagamento findByOrderId(Long pedidoId) throws ApiException {
        return (Pagamento)this.repository.findByPedidoId(pedidoId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pagamento", "{Pedido " + pedidoId.toString() + "}"}));
    }

    public Boolean fazPagamentoViaPagSeguro(Empresa empresa) {
        return StringUtil.isNotBlank((String)empresa.getTokenPagSeguro()) && StringUtil.isNotBlank((String)empresa.getEmailPagSeguro());
    }

    @Transactional
    public Pagamento save(Pedido order, TransactionDetail creditCardTransaction) {
        Pagamento payment = new Pagamento();
        payment.setDataHoraTransacao(creditCardTransaction.getLastEvent());
        payment.setPedido(order);
        payment.setTipoPagamento(TipoPagamento.CREDITO);
        payment.setQuantidadeParcelas(order.getParcelas());
        if (NullUtil.isNotNullOrZero((Number)order.getCartaoDoCliente().getId())) {
            payment.setCartaoDoCliente((CartaoDoCliente)this.cartaoRepository.findById((Object)order.getCartaoDoCliente().getId()).get());
        }
        payment.setStatus(StatusDaTransacao.get((int)creditCardTransaction.getStatus().getStatusId()));
        payment.setCodigoTransacao(creditCardTransaction.getCode());
        this.repository.save((Object)payment);
        return payment;
    }
}

