/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.ProvedorDePagamento;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.LogDePagamento;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.specification.builder.LogDePagamentoSpecificationBuilder;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.LogDePagamentoRepository;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogDePagamentoService {
    @Autowired
    private LogDePagamentoRepository repository;
    @Autowired
    private ClienteRepository customerRepository;
    @Autowired
    private EmpresaRepository companyRepository;

    public Page<LogDePagamento> filter(String search, Integer pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        LogDePagamentoSpecificationBuilder builder = new LogDePagamentoSpecificationBuilder(search);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("dataHoraDaTransacao"), (String)"desc");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable);
        return results;
    }

    @Transactional
    public void savePaymentLog(Pedido order, String transactionCode, int transactionStatus, ProvedorDePagamento paymentProvider) {
        LogDePagamento paymentLog = new LogDePagamento();
        paymentLog.setEmpresa((Empresa)this.companyRepository.findById((Object)order.getEmpresa().getId()).get());
        paymentLog.setCliente((Cliente)this.customerRepository.findById((Object)order.getCliente().getId()).get());
        String cartao = StringUtil.removerMascara((String)order.getCartaoDoCliente().getNumeroCartao());
        paymentLog.setUltimosDigitosDoCartao(new Long(cartao.substring(cartao.length() - 4, cartao.length())));
        paymentLog.setCpfInformadoDoCartao(StringUtil.removerMascara((String)order.getCartaoDoCliente().getCpf()));
        paymentLog.setDataHoraDaTransacao(new Date());
        paymentLog.setTotalDaTransacao(order.getTotalDoPedido());
        paymentLog.setCodigoTransacao(transactionCode);
        paymentLog.setStatusDaTransacao(Integer.valueOf(transactionStatus));
        paymentLog.setProvedorDePagamento(paymentProvider);
        paymentLog.setTitularDoCartao(order.getCartaoDoCliente().getTitular());
        this.repository.save((Object)paymentLog);
    }
}

