/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.domain.Message;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Emblema;
import com.escolpi.omni.api.model.entity.EmpresaProdutoEmDestaque;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.ProdutoDoCatalogo;
import com.escolpi.omni.api.model.entity.Promocao;
import com.escolpi.omni.api.model.entity.Segmento;
import com.escolpi.omni.api.model.projection.ProdutoView;
import com.escolpi.omni.api.model.projection.PromocaoView;
import com.escolpi.omni.api.util.EnviromentUtil;
import com.escolpi.omni.api.util.FileUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileService.class);
    @Autowired
    ServletContext context;

    public void copyDirectory(String sourceDirectoryLocation, String destinationDirectoryLocation) throws IOException {
        File sourceDirectory = new File(sourceDirectoryLocation);
        File destinationDirectory = new File(destinationDirectoryLocation);
        FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory);
    }

    public void copyFile(String sourceFilePath, String destinationFilePath) throws IOException {
        File sourceFile = new File(sourceFilePath);
        File destinationFile = new File(destinationFilePath);
        FileUtils.copyFile((File)sourceFile, (File)destinationFile);
    }

    public void deleteCompanyFolder(Long companyId) throws ApiException, IOException {
    }

    public File getFile(String caminhoArquivo) throws ApiException {
        try {
            Path path = FileUtil.getDir((String)caminhoArquivo);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            File arquivo = path.toFile();
            if (arquivo.isDirectory()) {
                throw new IllegalArgumentException("O par\u00e2metro \"caminho\" \u00e9 um diret\u00f3rio");
            }
            return arquivo;
        }
        catch (Exception e) {
            LOGGER.warn(Message.getInstance().getMessage("erro.api.padrao", new String[]{"ao obter arquivo: " + e.getMessage()}));
            return null;
        }
    }

    public String getEmblemsPath() throws ApiException {
        StringBuilder srcPath = new StringBuilder("https://imagens1.pedidoagora.com.br/").append("emblemas/");
        Path path = Paths.get(srcPath.toString(), new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new ApiException("erro.api.padrao", new String[]{"O Caminho dos emblemas n\u00e3o encontrado!"});
        }
        return path.toString();
    }

    public String getCompanyPath(String id, String extraPath, Boolean returnNullIfNotExists) throws ApiException {
        StringBuilder srcPath = new StringBuilder(EnviromentUtil.isJUnitTest() ? Domains.PATH_REPOSITORIO_API_TEST : Domains.PATH_REPOSITORIO_API).append(File.separator).append("empresas").append(File.separator).append(id);
        if (StringUtil.isNotBlank((String)extraPath)) {
            srcPath.append(File.separator).append(extraPath);
        }
        Path path = Paths.get(srcPath.toString(), new String[0]);
        return returnNullIfNotExists.booleanValue() ? (Files.notExists(path, new LinkOption[0]) ? null : path.toString()) : path.toString();
    }

    public String getCompanyUrl(Long id, String extraPath) {
        String url = "https://imagens1.pedidoagora.com.br/".concat("empresas/").concat(id.toString());
        if (StringUtil.isNotBlank((String)extraPath)) {
            return url.concat("/").concat(extraPath).concat("/");
        }
        return url;
    }

    public String getCompanyGaleryPath(Long empresaId, String subdir) throws ApiException {
        String uri = this.getCompanyPath(empresaId.toString(), null, Boolean.valueOf(true)) + File.separator + "galeria";
        if (StringUtil.isNotBlank((String)uri)) {
            Path path;
            if (StringUtil.isNotBlank((String)subdir)) {
                uri = uri + File.separator + subdir;
            }
            if (Files.notExists(path = Paths.get(uri, new String[0]), new LinkOption[0])) {
                LOGGER.warn(String.format("Caminho da Galeria de imagens da Empresa ID [%s] n\u00e3o foi encontrado!", empresaId));
            }
            return path.toString();
        }
        return null;
    }

    public String getBlankPictureUrl() throws ApiException {
        return "https://imagens1.pedidoagora.com.br/".concat("blank.jpg");
    }

    public String getPictureUrl(String filename) throws ApiException {
        return "https://imagens1.pedidoagora.com.br/".concat(filename);
    }

    public String getPictureUrl(Emblema emblem) throws ApiException {
        return "https://imagens1.pedidoagora.com.br/".concat("emblemas/").concat(emblem.getCaminhoFoto());
    }

    public String getPictureUrl(CategoriaDoProduto category, boolean isThumbnail) {
        String filename = isThumbnail ? "_".concat(category.getCaminhoFoto()) : category.getCaminhoFoto();
        return this.getCompanyUrl(category.getEmpresa().getId(), "galeria/categorias/destaques").concat(filename);
    }

    public String getPictureUrl(EmpresaProdutoEmDestaque spotlight, boolean isThumbnail) {
        String filename = isThumbnail ? "_".concat(spotlight.getCaminhoFoto()) : spotlight.getCaminhoFoto();
        return this.getCompanyUrl(spotlight.getProduto().getEmpresa().getId(), "galeria/destaques").concat(filename);
    }

    public String getPictureUrl(Produto product, boolean isThumbnail) {
        if (StringUtil.isBlank((String)product.getCaminhoFoto())) {
            return "";
        }
        String filename = isThumbnail ? "_".concat(product.getCaminhoFoto()) : product.getCaminhoFoto();
        return this.getCompanyUrl(product.getEmpresa().getId(), "galeria/produtos").concat(filename);
    }

    public String getPictureUrl(ProdutoDoCatalogo product, boolean isThumbnail) {
        if (StringUtil.isBlank((String)product.getCaminhoFoto())) {
            return "";
        }
        String filename = isThumbnail ? "_".concat(product.getCaminhoFoto()) : product.getCaminhoFoto();
        return this.getCompanyUrl(product.getEmpresa().getId(), "galeria/produtos").concat(filename);
    }

    public String getPictureUrl(ProdutoView product, Long companyId, boolean isThumbnail) {
        if (StringUtil.isBlank((String)product.getCaminhoFoto())) {
            return "";
        }
        String filename = isThumbnail ? "_".concat(product.getCaminhoFoto()) : product.getCaminhoFoto();
        return this.getCompanyUrl(companyId, "galeria/produtos").concat(filename);
    }

    public String getPictureUrl(Promocao promotion, boolean isThumbnail) {
        String filename = isThumbnail ? "_".concat(promotion.getCaminhoFoto()) : promotion.getCaminhoFoto();
        return this.getCompanyUrl(promotion.getEmpresa().getId(), "galeria/promocoes").concat(filename);
    }

    public String getPictureUrl(PromocaoView promotion, Long companyId, boolean isThumbnail) {
        String filename = isThumbnail ? "_".concat(promotion.getCaminhoFoto()) : promotion.getCaminhoFoto();
        return this.getCompanyUrl(companyId, "galeria/promocoes").concat(filename);
    }

    public String getPictureUrl(Segmento segment) throws ApiException {
        return "https://imagens1.pedidoagora.com.br/".concat("segmentos/").concat(segment.getCaminhoFoto());
    }

    public String getRootPath() {
        Path path = Paths.get(EnviromentUtil.isJUnitTest() ? Domains.PATH_REPOSITORIO_API_TEST : Domains.PATH_REPOSITORIO_API, new String[0]);
        return Files.notExists(path, new LinkOption[0]) ? null : path.toString();
    }

    public String getDefaultsPath() {
        Path path = Paths.get((EnviromentUtil.isJUnitTest() ? Domains.PATH_REPOSITORIO_API_TEST : Domains.PATH_REPOSITORIO_API) + File.separator + "padroes", new String[0]);
        return Files.notExists(path, new LinkOption[0]) ? null : path.toString();
    }

    public String getThumnailFileName(String fileName) throws ApiException {
        if (StringUtil.isBlank((String)fileName)) {
            throw new ApiException("erro.api.padrao", new String[]{"O par\u00e2metro \"filename\" n\u00e3o foi informado!"});
        }
        return "_".concat(fileName);
    }

    public void saveBase64File(String caminhoArquivo, String arquivoBase64) throws ApiException {
        try {
            byte[] bytes = FileUtil.decodeBase64((String)arquivoBase64);
            Path path = Files.createFile(Paths.get(caminhoArquivo, new String[0]), new FileAttribute[0]);
            Files.write(path, bytes, new OpenOption[0]);
            File savedPicture = new File(path.toString());
            savedPicture.setExecutable(true, false);
            savedPicture.setWritable(true, false);
            savedPicture.setReadable(true, false);
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.warn("A imagem n\u00e3o foi salva porque ela j\u00e1 existe!");
        }
        catch (IOException e) {
            throw new ApiException("erro.api.padrao", new String[]{"Erro ao salvar arquivo: " + e.getMessage()});
        }
    }

    public void saveThumbnailFile(String filePath, String base64File, int thumbnailSize) throws ApiException {
        try {
            File originalImg = this.getFile(filePath);
            if (originalImg.exists()) {
                String thumbFilePath = filePath.substring(0, filePath.lastIndexOf(File.separator) + 1) + "_" + filePath.substring(filePath.lastIndexOf(File.separator) + 1, filePath.length());
                ByteArrayOutputStream thumbOutput = new ByteArrayOutputStream();
                FileOutputStream thumbFileOutput = new FileOutputStream(thumbFilePath);
                BufferedImage thumbImg = null;
                BufferedImage img = ImageIO.read(originalImg);
                thumbImg = Scalr.resize((BufferedImage)img, (Scalr.Method)Scalr.Method.SPEED, (int)thumbnailSize, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                ImageIO.write((RenderedImage)thumbImg, StringUtil.obterExtensao((String)filePath).replace(".", ""), thumbOutput);
                thumbOutput.writeTo(thumbFileOutput);
                File savedThumb = new File(thumbFilePath);
                savedThumb.setExecutable(true, false);
                savedThumb.setWritable(true, false);
                savedThumb.setReadable(true, false);
            }
        }
        catch (IOException e) {
            throw new ApiException("erro.api.padrao", new String[]{"Erro ao salvar miniatura: " + e.getMessage()});
        }
    }
}

