/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Emblema;
import com.escolpi.omni.api.model.specification.builder.EmblemaSpecificationBuilder;
import com.escolpi.omni.api.repository.EmblemaRepository;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmblemaService
implements BaseCrudService<Emblema, Long> {
    @Autowired
    private EmblemaRepository repository;
    @Autowired
    private FileService fileService;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            this.repository.deleteById((Object)id);
        }
        catch (Exception e) {
            throw new ApiException("erro.entitidade.vinculado", new String[]{"Emblema"});
        }
    }

    public Page<Emblema> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        EmblemaSpecificationBuilder builder = new EmblemaSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<Emblema> findAll(Long empresaId) throws ApiException {
        List emblemas = this.repository.findAll();
        for (Emblema emblema : emblemas) {
            emblema.setFoto(this.fileService.getPictureUrl(emblema));
        }
        return emblemas;
    }

    public Emblema findById(Long id) throws ApiException {
        Emblema emblema = (Emblema)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Emblema", id.toString()}));
        emblema.setFoto(this.fileService.getPictureUrl(emblema));
        return emblema;
    }

    public void save(Emblema entity) throws ApiException {
    }

    public void validate(Emblema entity) throws ApiException {
    }
}

