/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CupomUtilizado;
import com.escolpi.omni.api.model.specification.builder.CupomUtilizadoSpecificationBuilder;
import com.escolpi.omni.api.repository.CupomUtilizadoRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CupomUtilizadoService
implements BaseCrudService<CupomUtilizado, Long> {
    @Autowired
    private CupomUtilizadoRepository cupomUtilizadoRepository;

    @Transactional
    public void delete(Long id) throws ApiException {
        this.cupomUtilizadoRepository.deleteById((Object)id);
    }

    public List<CupomUtilizado> findAll(Long empresaId) throws ApiException {
        return this.cupomUtilizadoRepository.findByEmpresaIdOrderByIdDesc(empresaId);
    }

    public CupomUtilizado findById(Long id) throws ApiException {
        return (CupomUtilizado)this.cupomUtilizadoRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cupom Utilizado", id.toString()}));
    }

    @Transactional
    public void save(CupomUtilizado cupomUtilizado) throws ApiException {
        this.validate(cupomUtilizado);
        if (NullUtil.isNotNull((Object)cupomUtilizado.getId())) {
            throw new ApiException("msg.erro.049", new String[]{"Cupom Utilizado"});
        }
        this.cupomUtilizadoRepository.save((Object)cupomUtilizado);
    }

    public void validate(CupomUtilizado cupomUtilizado) throws ApiException {
        if (!NullUtil.isNotNull((Object)cupomUtilizado.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (!NullUtil.isNotNull((Object)cupomUtilizado.getEmpresa().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"ID da Empresa"});
        }
        if (!NullUtil.isNotNull((Object)cupomUtilizado.getCliente())) {
            throw new ApiException("msg.erro.001", new String[]{"Cliente"});
        }
        if (!NullUtil.isNotNull((Object)cupomUtilizado.getCliente().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"ID do Cliente"});
        }
        if (!NullUtil.isNotNull((Object)cupomUtilizado.getCupom())) {
            throw new ApiException("msg.erro.001", new String[]{"Cupom de Desconto"});
        }
        if (!NullUtil.isNotNull((Object)cupomUtilizado.getCupom().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"ID do Cupom de Desconto"});
        }
    }

    public Page<CupomUtilizado> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        CupomUtilizadoSpecificationBuilder builder = new CupomUtilizadoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.cupomUtilizadoRepository.findAll(spec, (Pageable)pageable);
    }
}

