/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.enumeration.TipoUtilizacaoCupom;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.model.entity.CupomUtilizado;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.model.specification.builder.CupomDeDescontoSpecificationBuilder;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.CupomDeDescontoRepository;
import com.escolpi.omni.api.repository.CupomUtilizadoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CupomDeDescontoService
implements BaseCrudService<CupomDeDesconto, Long> {
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private CupomUtilizadoRepository cupomUtilizadoRepository;
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private CupomDeDescontoRepository repository;

    public List<AutocompleteView> searchByAutocomplete(Long empresaId, String searchTerm) {
        return this.repository.searchByAutoComplete(empresaId, searchTerm);
    }

    @Transactional
    public void delete(Long id) throws ApiException {
        CupomDeDesconto entryToDelete = (CupomDeDesconto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cupom de Desconto", id.toString()}));
        entryToDelete.setExcluido(Boolean.TRUE);
        this.repository.save((Object)entryToDelete);
    }

    public Page<CupomDeDesconto> filter(String searchCriteria, int numeroPagina, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        CupomDeDescontoSpecificationBuilder builder = new CupomDeDescontoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)numeroPagina, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<CupomDeDesconto> findAll(Long empresaId) {
        return this.repository.findByEmpresaId(empresaId);
    }

    public List<CupomDeDesconto> findAllActive(Long empresaId) {
        return this.repository.findCurrentByEmpresaId(empresaId);
    }

    public CupomDeDesconto findById(Long id) throws ApiException {
        return (CupomDeDesconto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cupom de Desconto", id.toString()}));
    }

    public CupomDeDesconto findById(Long id, Long empresaId) throws ApiException {
        CupomDeDesconto cupom = (CupomDeDesconto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cupom de Desconto", id.toString()}));
        if (!cupom.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculado", new String[]{Entidade.CUPOM_DE_DESCONTO.getDescricao()});
        }
        return cupom;
    }

    public CupomDeDesconto obterCupomDeDesconto(Long empresaId, Long id, Long clienteId) throws ApiException {
        if (!NullUtil.isNotNullOrZero((Number)id)) {
            throw new ApiException("msg.erro.016");
        }
        CupomDeDesconto cupom = (CupomDeDesconto)this.repository.findByIdAndExcluidoIsFalse(id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cupom de Desconto", id.toString()}));
        if (!NullUtil.isNotNull((Object)cupom)) {
            throw new ApiException("msg.erro.016");
        }
        Long atual = new Date().getTime();
        Long inicio = cupom.getDataInicioValidade().getTime();
        Long fim = cupom.getDataFimValidade().getTime();
        if (atual > fim || atual < inicio) {
            throw new ApiException("msg.erro.017");
        }
        Cliente cliente = (Cliente)this.clienteRepository.findById((Object)clienteId).orElseThrow(() -> new ApiException("msg.erro.entidade.nao.encontrado", new String[]{"Cliente", id.toString()}));
        this.validarUtilizacaoDoCupomDeDesconto(cliente, cupom);
        return cupom;
    }

    private void validarUtilizacaoDoCupomDeDesconto(Cliente cliente, CupomDeDesconto cupom) throws ApiException {
        List cuponsUtilizados = this.cupomUtilizadoRepository.findByCupomIdAndEmpresaIdAndClienteId(cupom.getId(), cliente.getEmpresa().getId(), cliente.getId());
        for (CupomUtilizado cupomUtilizado : cuponsUtilizados) {
            if (cupom.getTipoUtilizacao().equals((Object)TipoUtilizacaoCupom.UNICA)) {
                if (!cupom.getCodigo().equals(cupomUtilizado.getCupom().getCodigo()) || !DateUtil.isMesmaData((Date)cupom.getDataInicioValidade(), (Date)cupomUtilizado.getCupom().getDataInicioValidade()).booleanValue() || !DateUtil.isMesmaData((Date)cupom.getDataFimValidade(), (Date)cupomUtilizado.getCupom().getDataFimValidade()).booleanValue()) continue;
                throw new ApiException("msg.erro.022");
            }
            if (!cupom.getTipoUtilizacao().equals((Object)TipoUtilizacaoCupom.DIARIA)) continue;
            Empresa empresa = (Empresa)this.empresaRepository.findById((Object)cliente.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", cliente.getEmpresa().getId().toString()}));
            if (!DateUtil.isMesmaData((Date)cupomUtilizado.getDataHoraUsoDoCupom(), (Date)DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario())).booleanValue()) continue;
            throw new ApiException("msg.erro.070");
        }
    }

    @Transactional
    public void save(CupomDeDesconto cupom) throws ApiException {
        cupom.setEmpresa((Empresa)this.empresaRepository.findById((Object)cupom.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", cupom.getEmpresa().getId().toString()})));
        this.validate(cupom);
        if (NullUtil.isNotNullOrZero((Number)cupom.getId())) {
            CupomDeDesconto edit = (CupomDeDesconto)this.repository.findById((Object)cupom.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cupom de Desconto", cupom.getId().toString()}));
            edit.setDataFimValidade(cupom.getDataFimValidade());
            edit.setDataInicioValidade(cupom.getDataInicioValidade());
            edit.setTipoDesconto(cupom.getTipoDesconto());
            edit.setTipoRegra(cupom.getTipoRegra());
            edit.setValorDesconto(cupom.getValorDesconto());
            edit.setValorRegraCupom(cupom.getValorRegraCupom());
            edit.setTipoUtilizacao(cupom.getTipoUtilizacao());
            edit.setExcluido(NullUtil.isNotNull((Object)cupom.getExcluido()) ? cupom.getExcluido() : Boolean.FALSE);
            this.repository.save((Object)edit);
            return;
        }
        cupom.setExcluido(Boolean.valueOf(false));
        this.repository.save((Object)cupom);
    }

    public void validate(CupomDeDesconto cupom) throws ApiException {
        if (!NullUtil.isNotNull((Object)cupom)) {
            throw new ApiException("msg.erro.001", new String[]{"Cupom"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getCodigo())) {
            throw new ApiException("msg.erro.001", new String[]{"C\u00f3digo do Cupom"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getDataInicioValidade())) {
            throw new ApiException("msg.erro.001", new String[]{"Data inicial de validade do Cupom"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getDataFimValidade())) {
            throw new ApiException("msg.erro.001", new String[]{"Data final de validade do Cupom"});
        }
        if (DateUtil.isPassado((Date)cupom.getDataFimValidade()).booleanValue()) {
            throw new ApiException("msg.erro.069", new String[]{"Data final de validade do Cupom"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getTipoDesconto())) {
            throw new ApiException("msg.erro.001", new String[]{"Tipo de Desconto"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getTipoRegra())) {
            throw new ApiException("msg.erro.001", new String[]{"Tipo de Regra"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getValorDesconto())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor do Desconto"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getValorRegraCupom())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor da Regra"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (!NullUtil.isNotNull((Object)cupom.getEmpresa().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"ID da Empresa"});
        }
    }
}

