/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.ConfiguracaoDePizzaria;
import com.escolpi.omni.api.model.entity.id.EmpresaId;
import com.escolpi.omni.api.repository.ConfiguracaoDePizzariaRepository;
import com.escolpi.omni.api.repository.EmpresaIdRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.NullUtil;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class ConfiguracaoDePizzariaService
implements BaseCrudService<ConfiguracaoDePizzaria, Long> {
    private static final Integer LIMITE_MAXIMO_OPCOES = 4;
    @Autowired
    private ConfiguracaoDePizzariaRepository repository;
    @Autowired
    private EmpresaIdRepository companyRepository;

    public void delete(Long id) throws ApiException {
    }

    public Page<ConfiguracaoDePizzaria> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        return null;
    }

    public List<ConfiguracaoDePizzaria> findAll(Long empresaId) throws ApiException {
        return this.repository.findAll();
    }

    public ConfiguracaoDePizzaria findById(Long id) throws ApiException {
        return (ConfiguracaoDePizzaria)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o de Pizzaria"}));
    }

    public ConfiguracaoDePizzaria findByCompany(Long companyId) throws ApiException {
        return (ConfiguracaoDePizzaria)this.repository.findByEmpresaId(companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o de Pizzaria", companyId.toString()}));
    }

    @Transactional
    public void save(ConfiguracaoDePizzaria entity) throws ApiException {
        this.validate(entity);
        if (NullUtil.isNotNullOrZero((Number)entity.getId())) {
            ConfiguracaoDePizzaria edit = this.populate(entity);
            this.repository.save((Object)edit);
        }
        entity.setEmpresa((EmpresaId)this.companyRepository.findById((Object)entity.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa"})));
        this.repository.save((Object)entity);
    }

    public void validate(ConfiguracaoDePizzaria entity) throws ApiException {
        if (NullUtil.isNull((Object)entity.getCriterioDeCalculo())) {
            throw new ApiException("msg.erro.001 ", new String[]{"Crit\u00e9rio de C\u00e1lculo"});
        }
        if (NullUtil.isNotNullOrZero((Number)entity.getLimiteSelecaoTamanhoBroto()) && entity.getLimiteSelecaoTamanhoBroto() > LIMITE_MAXIMO_OPCOES) {
            throw new ApiException("msg.erro.188", new String[]{"Limite de Sele\u00e7\u00e3o Tam. Broto", LIMITE_MAXIMO_OPCOES.toString()});
        }
        if (NullUtil.isNotNullOrZero((Number)entity.getLimiteSelecaoTamanhoMedio()) && entity.getLimiteSelecaoTamanhoMedio() > LIMITE_MAXIMO_OPCOES) {
            throw new ApiException("msg.erro.188", new String[]{"Limite de Sele\u00e7\u00e3o Tam. M\u00e9dio", LIMITE_MAXIMO_OPCOES.toString()});
        }
        if (NullUtil.isNotNullOrZero((Number)entity.getLimiteSelecaoTamanhoGrande()) && entity.getLimiteSelecaoTamanhoGrande() > LIMITE_MAXIMO_OPCOES) {
            throw new ApiException("msg.erro.188", new String[]{"Limite de Sele\u00e7\u00e3o Tam. Grande", LIMITE_MAXIMO_OPCOES.toString()});
        }
        if (NullUtil.isNotNullOrZero((Number)entity.getLimiteSelecaoTamanhoGigante()) && entity.getLimiteSelecaoTamanhoGigante() > LIMITE_MAXIMO_OPCOES) {
            throw new ApiException("msg.erro.188", new String[]{"Limite de Sele\u00e7\u00e3o Tam. Grande", LIMITE_MAXIMO_OPCOES.toString()});
        }
    }

    private ConfiguracaoDePizzaria populate(ConfiguracaoDePizzaria config) throws ApiException {
        ConfiguracaoDePizzaria edit = this.findById(config.getId());
        edit.setCriterioDeCalculo(config.getCriterioDeCalculo());
        edit.setLabelTamanhoBroto(config.getLabelTamanhoBroto());
        edit.setLabelTamanhoMedio(config.getLabelTamanhoMedio());
        edit.setLabelTamanhoGrande(config.getLabelTamanhoGrande());
        edit.setLabelTamanhoGigante(config.getLabelTamanhoGigante());
        edit.setLimiteSelecaoTamanhoGigante(edit.getLimiteSelecaoTamanhoBroto());
        edit.setLimiteSelecaoTamanhoMedio(config.getLimiteSelecaoTamanhoMedio());
        edit.setLimiteSelecaoTamanhoGrande(edit.getLimiteSelecaoTamanhoGrande());
        edit.setLimiteSelecaoTamanhoGrande(config.getLimiteSelecaoTamanhoGigante());
        return edit;
    }
}

