/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.ui;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CategoriaDoProdutoService;
import com.escolpi.omni.api.service.CupomDeDescontoService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.MunicipioService;
import com.escolpi.omni.api.service.PersonalizacaoService;
import com.escolpi.omni.api.service.ProdutoService;
import com.escolpi.omni.api.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ui/autocomplete/{companyId}"})
public class AutoCompleteResource
extends BaseResource {
    @Autowired
    private CategoriaDoProdutoService categoriaDoProdutoService;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private CupomDeDescontoService cupomDeDescontoService;
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private PersonalizacaoService personalizacaoService;
    @Autowired
    private ProdutoService produtoService;

    @GetMapping(value={"/empresa/{searchTerm}"})
    public ResponseEntity<List<AutocompleteView>> searchCompanyByAutocomplete(@PathVariable String searchTerm) throws ApiException {
        return new ResponseEntity((Object)this.companyService.autocompleteByFancyName(searchTerm), HttpStatus.OK);
    }

    @GetMapping(value={"/categoria-do-produto/{searchTerm}"})
    public ResponseEntity<List<AutocompleteView>> searchProductCategoryByAutocomplete(@PathVariable Long companyId, @PathVariable(value="searchTerm") String searchTerm) throws ApiException {
        return new ResponseEntity((Object)this.categoriaDoProdutoService.searchByAutocomplete(companyId, searchTerm), HttpStatus.OK);
    }

    @GetMapping(value={"/cupom-de-desconto/{searchTerm}"})
    public ResponseEntity<List<AutocompleteView>> searchDisccountTicketByAutocomplete(@PathVariable Long companyId, @PathVariable(value="searchTerm") String searchTerm) throws ApiException {
        return new ResponseEntity((Object)this.cupomDeDescontoService.searchByAutocomplete(companyId, searchTerm), HttpStatus.OK);
    }

    @GetMapping(value={"/municipio/{searchTerm}"})
    public ResponseEntity<List<AutocompleteView>> searchCityByAutocomplete(@PathVariable Long companyId, @PathVariable(value="searchTerm") String searchTerm) throws ApiException {
        searchTerm = StringUtil.removerAcentos((String)searchTerm);
        return new ResponseEntity((Object)this.municipioService.searchByAutocomplete(companyId, searchTerm), HttpStatus.OK);
    }

    @GetMapping(value={"/personalizacao/{searchTerm}/{categoriaId}"})
    public ResponseEntity<List<AutocompleteView>> searchCustomizationByAutocomplete(@PathVariable Long companyId, @PathVariable String searchTerm, @PathVariable(value="categoriaId") Long categoriaId) throws ApiException {
        return new ResponseEntity((Object)this.personalizacaoService.searchByAutocomplete(companyId, categoriaId, searchTerm), HttpStatus.OK);
    }

    @GetMapping(value={"/produto/{searchTerm}"})
    public ResponseEntity<List<AutocompleteView>> searchProductByAutocomplete(@PathVariable Long companyId, @PathVariable(value="searchTerm") String searchTerm) throws ApiException {
        return new ResponseEntity((Object)this.produtoService.searchByAutocomplete(companyId, searchTerm), HttpStatus.OK);
    }

    @GetMapping(value={"/produto/{searchTerm}/{categoryId}"})
    public ResponseEntity<List<AutocompleteView>> searchProductByAutocompleteAndCategory(@PathVariable Long companyId, @PathVariable(value="searchTerm") String searchTerm, @PathVariable(value="categoryId") Long categoryId) throws ApiException {
        return new ResponseEntity((Object)this.produtoService.searchByAutocomplete(companyId, categoryId, searchTerm), HttpStatus.OK);
    }
}

