/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.portal;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Parceiro;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.Plano;
import com.escolpi.omni.api.model.entity.Segmento;
import com.escolpi.omni.api.model.projection.ConfiguracaoView;
import com.escolpi.omni.api.model.projection.EmpresaView;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.ParceiroService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.service.PlanoService;
import com.escolpi.omni.api.service.SegmentoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal"})
public class PortalResource {
    @Autowired
    private EmpresaService empresaService;
    @Autowired
    private BCryptPasswordEncoder encoder;
    @Autowired
    private ParceiroService partnerService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private PlanoService planService;
    @Autowired
    private SegmentoService segmentService;

    @GetMapping(value={"/empresas/{storeId}"})
    @Deprecated
    public ResponseEntity<EmpresaView> getCompanyByStoreId(@PathVariable String storeId) throws ApiException {
        return new ResponseEntity((Object)this.empresaService.getCompanyByStoreId(storeId), HttpStatus.OK);
    }

    @GetMapping(value={"/segmentos"})
    public List<Segmento> getSegments() throws ApiException {
        return this.segmentService.findAll();
    }

    @GetMapping(value={"/parceiros/{key}"})
    public Parceiro getPartnerByKey(@PathVariable String key) throws ApiException {
        return this.partnerService.findByLinkKey(key);
    }

    @GetMapping(value={"/planos"})
    public List<Plano> getPlans() {
        return this.planService.findAllActivePlans();
    }

    @GetMapping(value={"/empresas/{storeId}/configuracao/{configName}"})
    public ResponseEntity<ConfiguracaoView> findCompanyConfigByName(@PathVariable String storeId, @PathVariable String configName) throws ApiException {
        return new ResponseEntity((Object)this.empresaService.findCompanyConfigById(storeId, configName), HttpStatus.OK);
    }

    @GetMapping(value={"/empresas/{empresaId}/logging/logout"})
    public void saveLogoutLog(@PathVariable Long empresaId) throws ApiException {
        this.logService.save(empresaId, Entidade.USUARIO, Operacao.LOGOUT, "Logout realizado com sucesso!");
    }

    @GetMapping(value={"/{empresaId}/pedidos/ultimo-pedido-da-mesa"})
    public List<Pedido> obterUltimosPedidosDaMesa(@PathVariable Long empresaId, @RequestParam String mesa) {
        return this.pedidoService.getLastCustomerOrdersByTableNumber(empresaId, mesa);
    }

    @GetMapping(value={"/{empresaId}/pedidos/{pedidoId}/ultimo-pedido-da-mesa"})
    public Pedido obter(@PathVariable Long empresaId, @PathVariable Long pedidoId) throws ApiException {
        return this.pedidoService.get(empresaId, pedidoId);
    }

    @PutMapping(value={"/{empresaId}/rodizios/{casterId}/valores"})
    public Pedido updateCasterValues(@RequestBody Pedido caster) throws ApiException {
        return this.pedidoService.updateOrderCasterValues(caster);
    }

    @GetMapping(value={"/gerar-senha/{newPassword}"})
    public String gerarSenha(@PathVariable String newPassword) {
        return this.encoder.encode((CharSequence)newPassword);
    }
}

