/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.cadastro;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.enumeration.StatusDaTransacaoCielo;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Contratacao;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.PreCadastroDaEmpresa;
import com.escolpi.omni.api.model.entity.dto.CartaoDeCredito;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CieloService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.FactoryService;
import com.escolpi.omni.api.service.UsuarioService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresa/cadastro"})
public class CadastroEmpresaResource
extends BaseResource {
    @Autowired
    private EmpresaService service;
    @Autowired
    private CieloService cieloService;
    @Autowired
    private FactoryService factoryService;
    @Autowired
    private UsuarioService userService;

    @GetMapping(value={"/existente/{cnpjCpf}"})
    public boolean checkCompanyExists(@PathVariable String cnpjCpf) throws ApiException, IOException {
        return this.service.companyExists(cnpjCpf);
    }

    @GetMapping(value={"/login-existente/{login}"})
    public boolean checkLoginExists(@PathVariable String login) throws ApiException {
        return this.userService.userExists(login, Domains.PROFILE_COMPANY_ID);
    }

    @PostMapping
    public Empresa createCompany(@RequestBody PreCadastroDaEmpresa preRegistration) throws ApiException, IOException {
        Empresa company = this.factoryService.buildCompany(preRegistration = this.service.saveCompanyPreRegistration(preRegistration, true));
        if (company.getPlano().getId().equals(Domains.PLAN_FREE_ID)) {
            this.service.createContractToFreePlan(company);
        }
        return this.getCompanySummary(company);
    }

    @GetMapping(value={"/transacoes/bandeira/{cardNumber}"})
    public String findBrandByCardNumber(@PathVariable String cardNumber) throws ApiException, IOException {
        try {
            return this.cieloService.findBrandByCardNumber(cardNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    @GetMapping(value={"/{id}"})
    public Empresa get(@PathVariable Long id) throws ApiException {
        return this.service.findById(id);
    }

    @GetMapping(value={"/pre-cadastro/{id}"})
    public PreCadastroDaEmpresa getCompanyPreRegistration(@PathVariable Long id) throws ApiException {
        return this.service.findCompanyPreRegistration(id);
    }

    @PostMapping(value={"/transacoes/pagamento"})
    public boolean processPayment(@RequestBody CartaoDeCredito creditCard) throws ApiException, IOException {
        Contratacao contract = this.service.createContractToPaidPlan(creditCard);
        contract.setCartaoDaEmpresa(creditCard);
        String transactionCode = this.cieloService.convertAndSendContractPayment(contract);
        int transactionStatus = this.cieloService.getTransactionStatus(transactionCode);
        return transactionStatus == StatusDaTransacaoCielo.AUTHORIZED.getStatus() || transactionStatus == StatusDaTransacaoCielo.PAYMENT_CONFIRMED.getStatus();
    }

    @RequestMapping(value={"/pre-cadastro"}, method={RequestMethod.POST, RequestMethod.PUT})
    public PreCadastroDaEmpresa savePreRegistration(@RequestBody PreCadastroDaEmpresa preRegistration) throws ApiException {
        return this.service.saveCompanyPreRegistration(preRegistration, false);
    }

    private Empresa getCompanySummary(Empresa company) {
        Empresa result = new Empresa();
        result.setId(company.getId());
        result.setNomeFantasia(company.getNomeFantasia());
        result.setContato(company.getContato());
        result.setTelefonePrincipal(company.getTelefonePrincipal());
        result.setIdStore(company.getIdStore());
        result.setPlano(company.getPlano());
        result.setUsuario(company.getUsuario());
        result.getUsuario().setSenha(null);
        result.setPlano(company.getPlano());
        return result;
    }
}

