/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.dto.DataOptionGroup;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.ProdutoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/produtos/{empresaId}"})
public class ManterProdutoResource
extends BaseResource
implements BaseCrudResource<Produto, Long> {
    private Entidade entidade = Entidade.PRODUTO;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private ProdutoService service;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            this.service.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public Page<Produto> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) {
        search = search + "@@".concat("excluido:false");
        return this.service.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_OBTER') and #oauth2.hasScope('read')")
    public Produto get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            return this.service.findById(id, empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public List<Produto> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        try {
            return this.service.findAll(empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/options/category"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public List<DataOptionGroup> listAllProductsDataOptionGroupedByCategory(@PathVariable Long empresaId) throws ApiException {
        return this.service.listProductsDataOptionGroupByCategory(empresaId);
    }

    @PutMapping(value={"/reset-products"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void resetProducts(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        this.service.resetProducts(empresaId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody Produto produto) throws ApiException {
        try {
            this.service.save(produto);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody Produto produto) throws ApiException {
        try {
            this.service.save(produto);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/update-all"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void updateAll(@PathVariable(value="empresaId") Long empresaId, @RequestBody List<Produto> produtos) throws ApiException {
        try {
            this.service.updateAll(empresaId, produtos);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/update/prices/common"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void updatePrices(@PathVariable(value="empresaId") Long empresaId, @RequestBody List<Produto> produtos) throws ApiException {
        try {
            this.service.updatePrices(produtos);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/update/prices/pizza"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void updatePizzaPrices(@PathVariable(value="empresaId") Long empresaId, @RequestBody List<Produto> produtos) throws ApiException {
        try {
            this.service.updatePizzaPrices(produtos);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

