/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Parcelamento;
import com.escolpi.omni.api.service.ParcelamentoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/parcelamentos/{empresaId}"})
public class ManterParcelamentoResource {
    @Autowired
    private ParcelamentoService service;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PARCELAMENTO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable Long id) throws ApiException {
        this.service.delete(id);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PARCELAMENTO_OBTER') and #oauth2.hasScope('read')")
    public Parcelamento get(Long empresaId, Long id) throws ApiException {
        return this.service.get(id);
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PARCELAMENTO_LISTAR') and #oauth2.hasScope('read')")
    public List<Parcelamento> list(@PathVariable Long empresaId) throws ApiException {
        return this.service.list(empresaId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PARCELAMENTO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable Long empresaId, @RequestBody Parcelamento entity) throws ApiException {
        this.service.save(empresaId, entity);
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PARCELAMENTO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable Long empresaId, @RequestBody Parcelamento entity) throws ApiException {
        this.service.save(empresaId, entity);
    }
}

