/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.ConfiguracaoDePizzaria;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.MunicipioAtendido;
import com.escolpi.omni.api.model.projection.EmpresaView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.ConfiguracaoDePizzariaService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.UsuarioService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/empresas/{companyId}"})
public class ManterEmpresaResource
extends BaseResource
implements BaseCrudResource<Empresa, Long> {
    private Entidade entidade = Entidade.EMPRESA;
    @Autowired
    private EmpresaService service;
    @Autowired
    private ConfiguracaoDePizzariaService pizzaConfigService;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private UsuarioService usuarioService;

    @PutMapping(value={"/lock"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public Empresa changeLockingState(@PathVariable Long companyId) throws ApiException {
        return this.service.changeLockingState(companyId);
    }

    @PutMapping(value={"/open-close"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public ResponseEntity<EmpresaView> changeOpeningState(@PathVariable Long companyId) throws ApiException {
        return new ResponseEntity((Object)this.service.changeOpeningState(companyId), HttpStatus.OK);
    }

    @PutMapping(value={"/testing"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public Empresa changeTestingState(@PathVariable Long companyId) throws ApiException {
        return this.service.changeTestingState(companyId);
    }

    @DeleteMapping(value={"/remove-city"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void detachCity(@PathVariable Long companyId, @RequestParam(value="municipioAtendidoId") Long municipioAtendidoId) throws ApiException {
        this.service.detachCity(companyId, municipioAtendidoId);
    }

    @GetMapping(value={"/configuration/pizza"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<ConfiguracaoDePizzaria> getPizzaConfig(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.pizzaConfigService.findByCompany(companyId));
    }

    @GetMapping(value={"/attended-cities"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public List<MunicipioAtendido> findAttendedCities(@PathVariable Long companyId, Long id) throws ApiException {
        return this.service.findByEmpresaId(companyId);
    }

    @GetMapping(value={"/configuracao/{configName}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public EmpresaConfiguracao findCompanyConfig(@PathVariable Long companyId, @PathVariable(value="configName") String configName) throws ApiException {
        return this.service.findCompanyConfigById(companyId, configName);
    }

    @GetMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public Empresa get(@PathVariable Long companyId, Long id) throws ApiException {
        try {
            return this.service.findByIdWithMedias(companyId);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/is-blocked"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public Boolean isCompanyBlocked(@PathVariable Long companyId, Long id) throws ApiException {
        try {
            return this.usuarioService.checkIfCompanyIsBlocked(companyId);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/is-opened"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public boolean storeIsOpened(@PathVariable Long companyId) throws ApiException {
        try {
            return this.service.getOpeningState(companyId);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @PutMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable Long companyId, @RequestBody Empresa empresa) throws ApiException {
        try {
            this.service.save(empresa);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/medias"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void updateMedias(@PathVariable Long companyId, @RequestBody Empresa empresa) throws ApiException {
        try {
            this.service.updateMedias(empresa);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/settings"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void updateSettings(@PathVariable Long companyId, @RequestBody Empresa empresa) throws ApiException {
        try {
            this.service.updateSettings(empresa);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/update-times"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void updateDeliveryTime(@PathVariable Long companyId, @RequestBody Empresa empresa) throws ApiException {
        try {
            this.service.updateDeliveryTimes(empresa);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    public void delete(Long companyId, Long id) throws ApiException {
    }

    public Page<Empresa> filter(Long companyId, String search, Integer numeroPagina, List<String> sortBy, String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) {
        return null;
    }

    public List<Empresa> list(Long companyId) throws ApiException {
        return null;
    }

    public void save(@PathVariable Long companyId, @RequestBody Empresa empresa) throws ApiException {
    }

    @PostMapping(value={"/configuration/pizza"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public void savePizzaConfig(@RequestBody ConfiguracaoDePizzaria config) throws ApiException {
        this.pizzaConfigService.save(config);
    }

    @PutMapping(value={"/configuration/pizza"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public void updatePizzaConfig(@RequestBody ConfiguracaoDePizzaria config) throws ApiException {
        this.pizzaConfigService.save(config);
    }

    @PutMapping(value={"/update-token"})
    public void updateToken(@PathVariable Long companyId, @RequestBody String tokenFcm) throws ApiException {
        try {
            this.service.saveFcmToken(companyId, tokenFcm);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

