/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.CupomDeDescontoService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/cupons_desconto/{empresaId}"})
public class ManterCupomDeDescontoResource
extends BaseResource
implements BaseCrudResource<CupomDeDesconto, Long> {
    private Entidade entidade = Entidade.CUPOM_DE_DESCONTO;
    @Autowired
    private CupomDeDescontoService cupomDeDescontoService;
    @Autowired
    private LogDeAcessoService logService;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CUPOM_DESCONTO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            this.cupomDeDescontoService.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CUPOM_DESCONTO_LISTAR') and #oauth2.hasScope('write')")
    public Page<CupomDeDesconto> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String search, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        search = search + "@@".concat("excluido:false");
        return this.cupomDeDescontoService.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CUPOM_DESCONTO_OBTER') and #oauth2.hasScope('write')")
    public CupomDeDesconto get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            return this.cupomDeDescontoService.findById(id, empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CUPOM_DESCONTO_LISTAR') and #oauth2.hasScope('write')")
    public List<CupomDeDesconto> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.cupomDeDescontoService.findAll(empresaId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CUPOM_DESCONTO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody CupomDeDesconto cupom) throws ApiException {
        try {
            this.cupomDeDescontoService.save(cupom);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CUPOM_DESCONTO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody CupomDeDesconto cupom) throws ApiException {
        try {
            this.cupomDeDescontoService.save(cupom);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

