/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.CatalogoService;
import com.escolpi.omni.api.service.CategoriaDoProdutoService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/categoria/{empresaId}"})
public class ManterCategoriaDoProdutoResource
extends BaseResource
implements BaseCrudResource<CategoriaDoProduto, Long> {
    private Entidade entidade = Entidade.CATEGORIA_DO_PRODUTO;
    @Autowired
    private CategoriaDoProdutoService categoriaService;
    @Autowired
    private CatalogoService catalogoService;
    @Autowired
    private LogDeAcessoService logService;

    @GetMapping(value={"/count-pizza-categories"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_OBTER') and #oauth2.hasScope('read')")
    public Integer countPizzaCategories(@PathVariable(value="empresaId") Long companyId) {
        return this.categoriaService.countPizzaCategories(companyId);
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            this.categoriaService.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/{categoriaId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_OBTER') and #oauth2.hasScope('read')")
    public CategoriaDoProduto get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="categoriaId") Long id) throws ApiException {
        try {
            return this.categoriaService.findById(id, empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public List<CategoriaDoProduto> list(@PathVariable(value="empresaId") Long empresaId) {
        return this.categoriaService.findAll(empresaId);
    }

    @GetMapping(value={"/without-empty-categories"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public List<CategoriaDoProduto> findAllExceptMasterAndEmptyCategories(@PathVariable(value="empresaId") Long empresaId) {
        return this.catalogoService.findAllExceptMasterAndEmptyCategories(empresaId);
    }

    @GetMapping(value={"/with-subcategories"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public List<CategoriaDoProduto> findAllExceptMasterCategories(@PathVariable(value="empresaId") Long empresaId) {
        return this.catalogoService.findAllExceptMasterCategories(empresaId);
    }

    @GetMapping(value={"/parent-categories"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public List<CategoriaDoProduto> findAllParentCategories(@PathVariable(value="empresaId") Long empresaId) {
        return this.categoriaService.findAllParentCategories(empresaId);
    }

    @GetMapping(value={"/without-subcategories"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public List<CategoriaDoProduto> findAllWithoutSubcategories(@PathVariable(value="empresaId") Long empresaId) {
        return this.categoriaService.findAllWithoutSubcategories(empresaId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody CategoriaDoProduto entity) throws ApiException {
        try {
            this.categoriaService.save(entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody CategoriaDoProduto entity) throws ApiException {
        try {
            this.categoriaService.save(entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/update-activation"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void updateActivationState(@PathVariable(value="empresaId") Long empresaId, @RequestBody Set<CategoriaDoProduto> categories) throws ApiException {
        try {
            this.categoriaService.updateCategoriesActivationState(categories);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_LISTAR') and #oauth2.hasScope('read')")
    public Page<CategoriaDoProduto> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String search, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        search = search + "@@excluida:false";
        return this.categoriaService.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }
}

