/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.service.ProdutoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/produtos/{empresaId}"})
public class ProdutoResource {
    @Autowired
    private ProdutoService service;

    @GetMapping(value={"/filtro"})
    public Page<Produto> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filterAvaliableProducts(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/ofertas/filtro"})
    public Page<Produto> filterOnOffers(@PathVariable(value="empresaId") Long empresaId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filterAvaliableProducts(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/em-oferta"})
    public List<Produto> findByEmpresaIdAndEmOferta(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.findByEmpresaIdAndEmOferta(empresaId);
    }

    @GetMapping(value={"/"})
    public List<Produto> findByName(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="nome") String nome) throws ApiException {
        return this.service.findByEmpresaIdAndNome(empresaId, nome);
    }

    @GetMapping(value={"/categoria/{categoriaId}"})
    public List<Produto> findByNameAndCategory(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="categoriaId") Long categoriaId, @RequestParam(value="nome") String nome) throws ApiException {
        return this.service.findByNomeAndCategoriaId(nome, categoriaId, empresaId);
    }

    @PostMapping(value={"/estoque/indisponiveis"})
    public List<String> listUnavaliableProducts(@RequestBody List<Long> productIds) throws ApiException {
        return this.service.listUnavaliableProducts(productIds);
    }

    @GetMapping(value={"/{produtoId}"})
    public Produto obter(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="produtoId") Long produtoId) throws ApiException {
        return this.service.find(produtoId);
    }

    @GetMapping(value={"/rodizio/{productId}"})
    public Produto getCaster(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="productId") Long productId) throws ApiException {
        return this.service.findCasterById(productId);
    }

    @GetMapping(value={"/{usuarioId}/recomendados-por-perfil"})
    public List<Produto> listarProdutosRecomendadosPorPerfil(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="usuarioId") Long usuarioId) throws ApiException {
        return this.service.listRecommendedProductsByProfile(empresaId, usuarioId);
    }
}

