/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.service.ProdutoService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HomeResource
extends BaseResource {
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private MessengerService messengerService;
    @Autowired
    private ProdutoService produtoService;

    @GetMapping(value={"/check-connection"})
    public HttpStatus checkConnection() {
        return HttpStatus.OK;
    }

    @GetMapping(value={"home"})
    public String index() {
        return "Pedido Agora API Works!";
    }

    @GetMapping(value={"{empresaId}"})
    public void atualizarValorTotalPedidos(@PathVariable(value="empresaId") Long empresaId) {
        this.pedidoService.upadteTotalOrderValue(empresaId);
    }

    @PostMapping(value={"ifood/{empresaId}"})
    public void importFromIFood(@PathVariable(value="empresaId") Long empresaId, @RequestBody String url) throws ApiException, IOException {
        try {
            this.produtoService.importFromIFood(url, empresaId);
        }
        catch (Exception e) {
            this.logService.save(empresaId, Entidade.PRODUTO, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/test/messenger/{orderId}"})
    public void testSendMessage(@PathVariable Long orderId) throws ApiException {
        Pedido order = this.pedidoService.findById(orderId);
        this.messengerService.sendOrderMessage(order);
    }
}

