/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CupomDeDescontoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cupons/{empresaId}"})
public class CupomDeDescontoResource
extends BaseResource {
    @Autowired
    private CupomDeDescontoService cupomService;

    @GetMapping
    @PreAuthorize(value="hasAuthority('ROLE_CUPOM_DE_DESCONTO_OBTER') and #oauth2.hasScope('read')")
    public List<CupomDeDesconto> listarCuponsVigentes(@PathVariable Long empresaId) throws ApiException {
        return this.cupomService.findAllActive(empresaId);
    }

    @GetMapping(value={"/codigo/{idCupom}/{clienteId}"})
    @PreAuthorize(value="hasAuthority('ROLE_CUPOM_DE_DESCONTO_OBTER') and #oauth2.hasScope('read')")
    public CupomDeDesconto obterCupomDeDesconto(@PathVariable Long empresaId, @PathVariable Long idCupom, @PathVariable Long clienteId) throws ApiException {
        return this.cupomService.obterCupomDeDesconto(empresaId, idCupom, clienteId);
    }
}

