/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CancelamentoDaConta;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.dto.ClienteDto;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.ClienteService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/clientes/{companyId}"})
public class ClienteResource
extends BaseResource {
    @Autowired
    private ClienteService service;

    @PostMapping(value={"/ativar-conta"})
    @PreAuthorize(value="hasAuthority('ROLE_CONTA_ATIVAR') and #oauth2.hasScope('write')")
    public void accountActivate(@PathVariable Long companyId, @RequestParam String email, @RequestParam Integer numeroAutenticacao) throws ApiException {
        this.service.activateAccount(companyId, email, numeroAutenticacao);
    }

    @PostMapping(value={"/desativar-conta"})
    @PreAuthorize(value="hasAuthority('ROLE_CONTA_INATIVAR') and #oauth2.hasScope('write')")
    public void accountInactivate(@RequestBody CancelamentoDaConta cancelamento, @PathVariable Long companyId) throws ApiException {
        this.service.inactivateUserAccount(cancelamento, companyId);
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_CLIENTES_LISTAR') and #oauth2.hasScope('read')")
    public Page<Cliente> filter(@PathVariable(value="companyId") Long companyId, @RequestParam(value="search") String search, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    public Cliente get(@PathVariable Long id, @PathVariable Long companyId) throws ApiException {
        return this.service.findById(id);
    }

    @GetMapping(value={"/obter"})
    public ClienteDto getUser(@RequestParam(value="email") String login, @PathVariable(value="companyId") Long companyId) throws ApiException {
        return this.service.findByLogin(login, companyId);
    }

    @GetMapping(value={"/{customerId}/cartoes"})
    @PreAuthorize(value="hasAuthority('ROLE_CONTA_LISTAR_CARTOES') and #oauth2.hasScope('write')")
    public List<CartaoDoCliente> listCustomerCards(@PathVariable(value="customerId") Long customerId) {
        return this.service.listCustomerCards(customerId);
    }

    @PostMapping(value={"/solicitar-ativacao"})
    @PreAuthorize(value="hasAuthority('ROLE_CONTA_SOLICITAR_ATIVACAO') and #oauth2.hasScope('write')")
    public void requestNewAccountActivation(@PathVariable Long companyId, @RequestParam String email) throws ApiException {
        this.service.createNewActivationRequest(companyId, email, false);
    }

    @PostMapping(value={"/web/solicitar-ativacao"})
    @PreAuthorize(value="hasAuthority('ROLE_CONTA_SOLICITAR_ATIVACAO') and #oauth2.hasScope('write')")
    public void requestNewAccountActivationByWeb(@PathVariable Long companyId, @RequestParam String cpf) throws ApiException {
        this.service.createNewActivationRequest(companyId, cpf, true);
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_CONTA_EDITAR') and #oauth2.hasScope('write')")
    public boolean update(@RequestBody Cliente cliente, @PathVariable Long companyId) throws ApiException {
        return this.service.edit(cliente, companyId);
    }

    @GetMapping(value={"/{customerId}/validate/payment/code/{verificationCode}"})
    @PreAuthorize(value="hasAuthority('ROLE_CONTA_EDITAR') and #oauth2.hasScope('write')")
    public void validateOnlinePaymentConfirmationCode(@PathVariable Long customerId, @PathVariable Long verificationCode) throws ApiException {
        this.service.validateOnlinePaymentConfirmationCode(customerId, verificationCode);
    }
}

