/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.model.entity.dto.CardapioDaMesa;
import com.escolpi.omni.api.model.entity.dto.CatalogoDePersonalizacoes;
import com.escolpi.omni.api.model.projection.EmpresaProdutoEmDestaqueView;
import com.escolpi.omni.api.model.projection.ProdutoView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CatalogoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/catalogo/{empresaId}"})
public class CatalogoResource
extends BaseResource {
    @Autowired
    private CatalogoService service;

    @Deprecated
    @GetMapping(value={"/categoria/lista"})
    public List<CategoriaDoProduto> getCategoriesByCompany(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.listCategoriesByCompanyId(empresaId, Boolean.valueOf(false));
    }

    @GetMapping(value={"/categoria/{categoriaId}/ultimo-produto"})
    public Produto findTopProductByCategoryId(@PathVariable Long empresaId, @PathVariable Long categoriaId) throws ApiException {
        return this.service.findTopProductByCategoryId(empresaId, categoriaId);
    }

    @GetMapping(value={"/categoria/listagem"})
    public List<CategoriaDoProduto> getCategoriesByCompany(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="exclusivoMesa") Boolean exclusivoMesa) throws ApiException {
        return this.service.listCategoriesByCompanyId(empresaId, exclusivoMesa);
    }

    @GetMapping(value={"/subcategorias/{categoriaId}"})
    @Deprecated
    public List<CategoriaDoProduto> getSubcategoriesByCategory(@PathVariable(value="categoriaId") Long categoriaId) throws ApiException {
        return this.service.listarSubCategoriasDaCategoria(categoriaId);
    }

    @GetMapping(value={"/categoria/{categoriaId}/produto/lista"})
    public List<Produto> getCompanyProductsByCategory(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="categoriaId") Long categoriaId) throws ApiException {
        List products = this.service.listarProdutosPorEmpresaECategoria(empresaId, categoriaId);
        return products;
    }

    @GetMapping(value={"/categoria/produto/filtro"})
    @Deprecated
    public Page<Produto> getCompanyPagedProductsByCategory(@PathVariable(value="empresaId") Long empresaId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.paginateProductsByCompanyAndCategory(search, numeroPagina.intValue(), sortBy, sortDirection, Integer.valueOf(20));
    }

    @GetMapping(value={"/categoria/{categoriaId}/brinde/lista"})
    public List<Produto> getProdutsToGifts(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="categoriaId") Long categoriaId) throws ApiException {
        return this.service.listarProdutosParaBrinde(empresaId, categoriaId);
    }

    @GetMapping(value={"/mesa/catalogo"})
    public List<CardapioDaMesa> getTableMenu(@PathVariable(value="empresaId") Long companyId) throws ApiException {
        return this.service.listTableMenu(companyId);
    }

    @GetMapping(value={"/produtos/{productId}/personalizacoes"})
    public CatalogoDePersonalizacoes listCustomizationCatalogByProduct(@PathVariable Long productId) throws ApiException {
        return this.service.getCustomizationCatalogByProduct(productId);
    }

    @Deprecated
    @GetMapping(value={"/categorias-em-destaque"})
    public List<CategoriaDoProduto> listSpotlightCategoryByCompany(@PathVariable Long empresaId) throws ApiException {
        return this.service.listSpotlightCategoryByCompany(empresaId);
    }

    @Deprecated
    @GetMapping(value={"/produtos-em-destaque"})
    public List<EmpresaProdutoEmDestaqueView> listSpotlightProductsByCompany(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.listarProdutosEmDestaquePorEmpresa(empresaId);
    }

    @GetMapping(value={"/produtos-em-destaque/promocional"})
    public List<EmpresaProdutoEmDestaqueView> listPromotionalSpotlightProductsByCompany(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.listarProdutosEmDestaquePromocionaisPorEmpresa(empresaId);
    }

    @GetMapping(value={"/produtos/ofertas"})
    @Deprecated
    public List<Produto> listSomeOfferProducts(@PathVariable Long empresaId) throws ApiException {
        return this.service.listSomeOfferProducts(empresaId);
    }

    @GetMapping(value={"/valores-personalizacoes/sem-estoque"})
    public List<ValorDaPersonalizacao> listUnavaiableCustomizationValues(@RequestParam(value="customizationValueIds") List<Long> customizationIds) throws ApiException {
        return this.service.listUnavaiableCustomizationValues(customizationIds);
    }

    @GetMapping(value={"/produtos/previa"})
    @Deprecated
    public List<ProdutoView> listTempSpotlightProductsByCompany(@PathVariable Long empresaId) throws ApiException {
        return this.service.listTempSpotlightProductsByCompany(empresaId);
    }
}

