/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CartaoDoClienteService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cliente/cartoes/{empresaId}"})
public class CartaoDoClienteResource
extends BaseResource {
    @Autowired
    private CartaoDoClienteService service;

    @GetMapping(value={"/{cartaoId}/obter"})
    @PreAuthorize(value="hasAuthority('ROLE_CARTAO_CLIENTE_OBTER') and #oauth2.hasScope('read')")
    public CartaoDoCliente get(@PathVariable(value="cartaoId") Long cartaoId) throws ApiException {
        return this.service.findById(cartaoId);
    }

    @GetMapping(value={"/{clienteId}"})
    @PreAuthorize(value="hasAuthority('ROLE_CARTAO_CLIENTE_LISTAR') and #oauth2.hasScope('read')")
    public List<CartaoDoCliente> listUserCardsByCustomer(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="clienteId") Long clienteId) {
        return this.service.findCardsByCustomer(clienteId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_CARTAO_CLIENTE_CRIAR') and #oauth2.hasScope('write')")
    public void create(@PathVariable(value="empresaId") Long empresaId, @RequestBody CartaoDoCliente cartaoDoCliente) throws ApiException {
        this.service.save(cartaoDoCliente);
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_CARTAO_CLIENTE_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody CartaoDoCliente cartaoDoCliente) throws ApiException {
        this.service.save(cartaoDoCliente);
    }

    @DeleteMapping(value={"/{enderecoId}"})
    @PreAuthorize(value="hasAuthority('ROLE_CARTAO_CLIENTE_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="enderecoId") Long enderecoId) throws ApiException {
        this.service.delete(enderecoId);
    }
}

