/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.projection.UsuarioView;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface UsuarioRepository
extends JpaRepository<Usuario, Long>,
JpaSpecificationExecutor<Usuario> {
    public static final String ENTITY_NAME = "Usu\u00e1rio";

    @Query(value="SELECT COUNT(u) FROM Usuario u WHERE u.login = :login AND u.perfil.id = :profileId AND u.excluido IS FALSE")
    public Long countByLoginAndPerfil(@Param(value="profileId") Long var1, @Param(value="login") String var2);

    @Query(value="SELECT COUNT(u) FROM Usuario u WHERE u.login = :login AND u.perfil.id = :profileId AND u.id <> :id AND u.excluido IS FALSE")
    public Long countByLoginAndPerfil(@Param(value="id") Long var1, @Param(value="profileId") Long var2, @Param(value="login") String var3);

    @Query(value="SELECT COUNT(u) FROM Usuario u WHERE u.telefone = :telephone AND u.perfil.id = :profileId AND u.excluido IS FALSE")
    public Long countByTelefone(@Param(value="telephone") String var1, @Param(value="profileId") Long var2);

    @Query(value="SELECT COUNT(u) FROM Usuario u WHERE u.telefone = :telephone AND u.perfil.id = :profileId AND u.id <> :id AND u.excluido IS FALSE")
    public Long countByTelefone(@Param(value="id") Long var1, @Param(value="telephone") String var2, @Param(value="profileId") Long var3);

    public Optional<Usuario> findByIdAndExcluidoIsFalse(Long var1);

    public Optional<Usuario> findByEmpresaIdAndCodigoDoPdv(Long var1, Integer var2);

    public Optional<Usuario> findByLoginAndPerfilId(@Param(value="login") String var1, @Param(value="perfilId") Long var2);

    @Query(value="SELECT u FROM Usuario u INNER JOIN Cliente c ON c.usuario.id = u.id INNER JOIN Empresa e ON e.id = c.empresa.id WHERE u.login = :login AND e.id = :companyId AND u.excluido IS FALSE ")
    public Optional<Usuario> findByCustomerLoginAndEmpresaId(@Param(value="login") String var1, @Param(value="companyId") Long var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.UsuarioView(c.usuario.id, c.usuario.nome, c.usuario.login, c.usuario.bloqueado) FROM Cliente c WHERE c.id = ?1")
    public Optional<UsuarioView> findByCustomerId(Long var1);

    @Query(value="FROM Usuario u WHERE u.login = :login AND u.empresa.id = :companyId AND u.perfil.id = :profileId AND u.excluido IS FALSE")
    public Optional<Usuario> findByLoginAndCompanyAndProfile(@Param(value="login") String var1, @Param(value="companyId") Long var2, @Param(value="profileId") Long var3);

    @Query(value="FROM Usuario u WHERE u.login = :login AND u.perfil.id = :profile")
    public Optional<Usuario> findByLoginAndPerfil(@Param(value="login") String var1, @Param(value="profile") Long var2);

    @Query(value="SELECT u FROM Usuario u WHERE u.empresa.id = :companyId AND u.telefone = :telephone AND u.perfil.id = :profileId AND u.excluido IS FALSE")
    public Optional<Usuario> findByTelephoneCompanyAndProfile(@Param(value="telephone") String var1, @Param(value="companyId") Long var2, @Param(value="profileId") Long var3);

    @Modifying
    @Query(value="UPDATE Usuario u SET u.bloqueado = :lock WHERE u.id = :id")
    public void toggleUserLocking(@Param(value="id") Long var1, @Param(value="lock") Boolean var2);
}

