/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Promocao;
import com.escolpi.omni.api.model.projection.PromocaoView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PromocaoRepository
extends JpaRepository<Promocao, Long>,
JpaSpecificationExecutor<Promocao> {
    public static final String ENTITY_NAME = "Promo\u00e7\u00e3o";

    public void deleteByIdGreaterThan(@Param(value="id") Long var1);

    public List<Promocao> findByEmpresaIdAndExcluidaIsFalse(@Param(value="empresaId") Long var1) throws ApiException;

    @Query(value="SELECT p FROM Promocao p WHERE p.empresa.id = :empresaId AND p.ativo IS TRUE AND p.excluida IS FALSE AND CURRENT_DATE BETWEEN p.dtInicioValidade AND p.dtFimValidade AND p.disponibilidades LIKE CONCAT('%', :diasDaSemana, '%') ORDER BY p.titulo DESC")
    @Deprecated
    public List<Promocao> findPromocoesVigentes(@Param(value="empresaId") Long var1, @Param(value="diasDaSemana") String var2) throws ApiException;

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.PromocaoView(p.id, p.titulo, p.descricao, p.valorFixo, p.caminhoFoto, p.fotoExterna) FROM Promocao p WHERE p.empresa.id = :companyId AND p.ativo IS TRUE AND p.excluida IS FALSE AND CURRENT_DATE BETWEEN p.dtInicioValidade AND p.dtFimValidade AND p.disponibilidades LIKE CONCAT('%', :weekDays, '%') ORDER BY p.titulo DESC")
    public List<PromocaoView> findAvaliablePromotions(@Param(value="companyId") Long var1, @Param(value="weekDays") String var2);

    public Optional<Promocao> findTopByEmpresaIdAndExcluidaIsFalseOrderByIdDesc(@Param(value="empresaId") Long var1) throws ApiException;

    public Optional<Promocao> findTopByEmpresaIdAndExcluidaIsTrueOrderByIdDesc(@Param(value="empresaId") Long var1) throws ApiException;

    @Query(value="FROM Promocao p WHERE p.id =:id AND p.ativo = TRUE AND p.excluida IS FALSE AND CURRENT_DATE BETWEEN p.dtInicioValidade AND p.dtFimValidade ORDER BY p.titulo DESC")
    public Optional<Promocao> findPromocaoVigenteById(@Param(value="id") Long var1) throws ApiException;
}

