/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.model.projection.CategoriaDoProdutoView;
import com.escolpi.omni.api.model.projection.ProdutoView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProdutoRepository
extends JpaRepository<Produto, Long>,
JpaSpecificationExecutor<Produto> {
    public static final String ENTITY_NAME = "Produto";
    public static final String ENTITY_CASTER_NAME = "Rod\u00edzio";

    public Long countByCategoriaId(@Param(value="categoriaId") Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.CategoriaDoProdutoView(p.categoria.id, p.categoria.descricao, p.categoria.quantitativa, p.categoria.composicao, p.categoria.excluida,p.categoria.ativo) FROM Produto p WHERE p.id = ?1")
    public Optional<CategoriaDoProdutoView> findCategoryByProductId(Long var1);

    public List<Produto> findByEmpresaId(@Param(value="empresaId") Long var1);

    public List<Produto> findByEmpresaIdAndCategoriaIdAndIdNot(@Param(value="empresaId") Long var1, @Param(value="categoriaId") Long var2, @Param(value="id") Long var3);

    @Query(value="SELECT p FROM Produto p WHERE p.empresa.id = :empresaId AND p.valorDesconto > 0 AND p.categoria.ativo IS TRUE AND p.categoria.excluida IS FALSE AND p.excluido IS FALSE ORDER BY p.valorDesconto DESC, p.nome ASC")
    public List<Produto> findByEmpresaIdAndEmOferta(@Param(value="empresaId") Long var1);

    public List<Produto> findByEmpresaIdAndExcluidoIsFalse(@Param(value="empresaId") Long var1);

    public List<Produto> findByEmpresaIdAndCategoriaIdAndExcluidoIsFalseOrderByNome(@Param(value="empresaId") Long var1, @Param(value="categoriaId") Long var2);

    @Query(value="FROM Produto p WHERE p.empresa.id = :empresaId AND p.categoria.id = :categoriaId AND p.disponibilidades LIKE CONCAT('%', :diasDaSemana, '%') AND p.excluido IS FALSE ORDER BY p.nome ASC")
    public List<Produto> findAvaliableProductsByCategory(@Param(value="empresaId") Long var1, @Param(value="categoriaId") Long var2, @Param(value="diasDaSemana") String var3);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.AutocompleteView(CONCAT(p.categoria.descricao, ' - ', p.nome), p.id) FROM Produto p WHERE p.empresa.id = :companyId AND UNACCENT(p.nome) LIKE CONCAT('%', UNACCENT(:term), '%') AND p.excluido IS FALSE AND p.categoria.ativo IS TRUE AND p.categoria.excluida IS FALSE ORDER BY p.nome")
    public List<AutocompleteView> findByAutocomplete(@Param(value="companyId") Long var1, @Param(value="term") String var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.AutocompleteView(CONCAT(p.categoria.descricao, ' - ', p.nome), p.id) FROM Produto p WHERE p.empresa.id = :companyId AND p.categoria.id = :categoryId AND UNACCENT(p.nome) LIKE CONCAT('%', UNACCENT(:term), '%') AND p.excluido IS FALSE AND p.categoria.ativo IS TRUE AND p.categoria.excluida IS FALSE ORDER BY p.nome")
    public List<AutocompleteView> findByAutocomplete(@Param(value="companyId") Long var1, @Param(value="categoryId") Long var2, @Param(value="term") String var3);

    public List<Produto> findByIdIn(List<Long> var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.entity.Produto(p.id, p.nome, p.estoque, p.estoqueIlimitado) FROM Produto p WHERE id IN(:ids)")
    public List<Produto> findCompositionItems(@Param(value="ids") List<Long> var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ProdutoView(p.id, p.nome, p.descricao, p.disponibilidades, p.labelTamanhoBroto, p.labelTamanhoMedio, p.labelTamanhoGrande, p.labelTamanhoGigante, p.pesoMedio, p.valor, p.valorTamanhoBroto, p.valorTamanhoMedio, p.valorTamanhoGrande, p.valorTamanhoGigante, p.valorAtacado, p.vendaPorTamanho, p.vendaPorFracao, p.caminhoFoto, p.fotoExterna ) FROM Produto p WHERE id = :id AND p.disponibilidades LIKE CONCAT('%', :diaDaSemana, '%') AND p.emFalta IS FALSE AND p.excluido IS FALSE")
    public Optional<ProdutoView> findByIdToCatlog(@Param(value="id") Long var1, @Param(value="diaDaSemana") String var2);

    @Query(value="SELECT DISTINCT(prod) FROM Pedido p INNER JOIN p.itensDoPedido ip INNER JOIN ip.produto prod WHERE p.situacao = :situacao AND p.cliente.id = :clienteId AND prod.empresa.id = :empresaId AND (SELECT COUNT(prodItem) FROM ItemDoPedido item INNER JOIN item.produto prodItem WHERE prodItem.id = prod.id) >= 2 ORDER BY prod.nome")
    public List<Produto> findProdutosRecomendadosPorPerfilAndExcluidoIsFalse(@Param(value="empresaId") Long var1, @Param(value="clienteId") Long var2, @Param(value="situacao") SituacaoDoPedido var3, Pageable var4);

    public Optional<Produto> findTopByEmpresaIdOrderByIdDesc(@Param(value="empresaId") Long var1);

    public Optional<Produto> findTopByEmpresaIdAndCategoriaId(@Param(value="empresaId") Long var1, @Param(value="categoriaId") Long var2);

    public Produto findTopByEmpresaIdAndExcluidoIsFalseOrderByIdDesc(Long var1);

    public List<Produto> findByEmpresaIdAndCodigoAtosAndExcluidoIsFalse(Long var1, String var2);

    public Optional<Produto> findTopByEmpresaIdAndExcluidoIsFalseAndCodigoAtos(@Param(value="empresaId") Long var1, @Param(value="codigoAtos") String var2);

    @Query(value="FROM Produto p WHERE p.empresa.id = :empresaId AND p.excluido IS FALSE AND p.categoria.ativo IS TRUE AND UNACCENT(p.nome) LIKE CONCAT('%', UNACCENT(:nome), '%') ORDER BY p.nome")
    public List<Produto> findByEmpresaIdAndNomeAndExcluidoIsFalse(@Param(value="empresaId") Long var1, @Param(value="nome") String var2);

    @Query(value="FROM Produto p WHERE p.categoria.id = :categoriaId AND p.excluido IS FALSE AND p.categoria.ativo IS TRUE AND UNACCENT(p.nome) LIKE CONCAT('%', UNACCENT(:nome), '%') ORDER BY p.nome")
    public List<Produto> findByNomeAndCategoriaIdAndExcluidoIsFalse(@Param(value="nome") String var1, @Param(value="categoriaId") Long var2);

    @Query(value="SELECT p.* FROM produtos p INNER JOIN categorias_produtos c ON c.id = p.categoria_id WHERE p.empresa_id = :empresaId AND p.excluido IS FALSE AND p.ind_falta IS FALSE AND p.caminho_foto IS NOT NULL AND p.caminho_foto <> '' AND c.ind_ativo IS TRUE AND c.ind_excluida IS FALSE AND p.ind_exibe_tela_inicial IS TRUE AND (p.valor_desconto IS NULL OR p.valor_desconto = 0) ORDER BY RANDOM() LIMIT 12", nativeQuery=true)
    public List<Produto> listRandomProductsToCatalog(@Param(value="empresaId") Long var1);

    @Query(value="SELECT p.* FROM produtos p INNER JOIN categorias_produtos c ON c.id = p.categoria_id WHERE p.empresa_id = :empresaId AND p.caminho_foto IS NOT NULL AND p.excluido IS FALSE AND p.ind_falta IS FALSE AND p.valor_desconto > 0 AND c.ind_ativo IS TRUE AND c.ind_excluida IS FALSE AND p.ind_exibe_tela_inicial IS TRUE ORDER BY RANDOM() LIMIT 12", nativeQuery=true)
    public List<Produto> listRandomProductsOnOffer(@Param(value="empresaId") Long var1);
}

