/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.util.NullUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class ProdutoSpecification
implements Specification<Produto> {
    private static final long serialVersionUID = -5248019257228059318L;
    private SearchCriteria criteria;

    public Predicate toPredicate(Root<Produto> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (NullUtil.isNull((Object)this.criteria.getValue()) || this.criteria.getValue().equals("undefined")) {
            return null;
        }
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("categoriaId")) {
            return builder.equal((Expression)root.get("categoria").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("categoriaAtiva")) {
            return builder.equal((Expression)root.get("categoria").get("ativo"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("categoriaDeRodizio")) {
            return builder.equal((Expression)root.get("categoriaDeRodizio").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("emFalta") && Long.valueOf(this.criteria.getValue().toString()).equals(0L)) {
            return builder.equal((Expression)root.get("emFalta"), (Object)false);
        }
        if (this.criteria.getKey().equals("vendaPorTamanho")) {
            return builder.equal((Expression)root.get("vendaPorTamanho"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("excluido")) {
            return builder.equal((Expression)root.get("excluido"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("rodizio")) {
            return builder.equal((Expression)root.get("rodizio"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("emOferta")) {
            return builder.greaterThan((Expression)root.get("valorDesconto"), (Comparable)Long.valueOf(0L));
        }
        if (this.criteria.getKey().equals("disponibilidades")) {
            return builder.like((Expression)root.get("disponibilidades"), "%" + this.criteria.getValue().toString() + "%");
        }
        if (this.criteria.getKey().equals("\t")) {
            return builder.equal((Expression)root.get("disponivelParaORodizio"), this.criteria.getValue());
        }
        if (this.criteria.getOperation().equalsIgnoreCase(">")) {
            if (this.criteria.getKey().equals("menorValor")) {
                return builder.greaterThanOrEqualTo((Expression)root.get("valor"), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase("<")) {
            if (this.criteria.getKey().equals("maiorValor")) {
                return builder.lessThanOrEqualTo((Expression)root.get("valor"), (Comparable)((Object)this.criteria.getValue().toString()));
            }
            return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (!this.criteria.getKey().equals("emFalta") && !this.criteria.getKey().equals("categoriaAtiva") && !this.criteria.getKey().equals("emOferta") && this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }

    public ProdutoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }
}

