/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.model.entity.PersonalizacaoDeProduto;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class PersonalizacaoDeProdutoSpecification
implements Specification<PersonalizacaoDeProduto> {
    private static final long serialVersionUID = 6846964609061103615L;
    private SearchCriteria criteria;

    public PersonalizacaoDeProdutoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<PersonalizacaoDeProduto> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("excluido")) {
            return builder.equal((Expression)root.get("excluido"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("produto").get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("produtoId")) {
            return builder.equal((Expression)root.get("produto").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("categoriaId")) {
            return builder.equal((Expression)root.get("produto").get("categoria").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("descricao")) {
            return builder.like(builder.upper(builder.function("unaccent", String.class, new Expression[]{root.get("descricao")})), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("nomeProduto")) {
            return builder.like(builder.upper(builder.function("unaccent", String.class, new Expression[]{root.get("produto").get("nome")})), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("multiOpcional")) {
            return builder.equal((Expression)root.get("multiOpcional"), this.criteria.getValue());
        }
        return null;
    }
}

