/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.enumeration.DiaDaSemana;
import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.util.DateUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class PedidoSpecification
implements Specification<Pedido> {
    private static final long serialVersionUID = 4181745594936172535L;
    private SearchCriteria criteria;

    public PedidoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<Pedido> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("clienteId")) {
            return builder.equal((Expression)root.get("cliente").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("clienteNome")) {
            return builder.or((Expression)builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("cliente").get("nome"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%"), (Expression)builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("nomeClienteMesa"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%"));
        }
        if (this.criteria.getKey().equals("mesa")) {
            return builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("mesa"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("cupomDesconto")) {
            return builder.equal((Expression)root.get("cupomDeDesconto").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("dataExpedienteInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataAtualizacaoPedido"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataExpedienteFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataAtualizacaoPedido"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataHoraPedidoInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataHoraPedido"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataHoraPedidoFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataHoraPedido"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("formaEntrega")) {
            return builder.equal((Expression)root.get("formaEntrega"), (Object)FormaDeEntrega.valueOf((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("valorInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.join("itensDoPedido").get("valor"), (Comparable)new BigDecimal((Long)this.criteria.getValue()));
        }
        if (this.criteria.getKey().equals("valorFim")) {
            return builder.lessThanOrEqualTo((Expression)root.join("itensDoPedido").get("valor"), (Comparable)new BigDecimal((Long)this.criteria.getValue()));
        }
        if (this.criteria.getKey().equals("situacao")) {
            return builder.equal((Expression)root.get("situacao"), (Object)SituacaoDoPedido.valueOf((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("rodizio")) {
            return builder.equal((Expression)root.get("rodizio"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("situacoes")) {
            List<String> situacoes = this.criteria.getValue().toString().contains(",") ? Stream.of(((String)this.criteria.getValue()).split("\\s*,\\s*")).map(String::trim).collect(Collectors.toList()) : Arrays.asList(this.criteria.getValue().toString());
            CriteriaBuilder.In inSituacoes = builder.in((Expression)root.get("situacao"));
            for (String situacao : situacoes) {
                inSituacoes.value((Object)DiaDaSemana.get((int)Integer.valueOf(situacao)));
            }
            return inSituacoes;
        }
        if (this.criteria.getKey().equals("classificacao")) {
            return builder.equal((Expression)root.get("classificacao"), (Object)new Integer(this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("feedback")) {
            return builder.isNotNull((Expression)root.get("classificacao"));
        }
        if (this.criteria.getKey().equals("sugestaoMelhoria")) {
            return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().contentEquals("notScheduled")) {
            return builder.notEqual((Expression)root.get("situacao"), (Object)SituacaoDoPedido.AGENDADO);
        }
        if (this.criteria.getOperation().equalsIgnoreCase(">")) {
            return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase("<")) {
            return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }
}

