/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.entity.PersonalizacaoDeProduto;
import com.escolpi.omni.api.model.entity.Produto;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="valores_personalizacoes")
@SequenceGenerator(name="valores_personalizacoes_gen", sequenceName="valores_personalizacoes_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
public class ValorDaPersonalizacao
implements Serializable {
    private static final long serialVersionUID = 4918726849607197713L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="valores_personalizacoes_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="personalizacao_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"categoria", "valoresDaPersonalizacao", "proximaPersonalizacao"})
    private Personalizacao personalizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="personalizacao_produto_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"valoresDaPersonalizacao"})
    private PersonalizacaoDeProduto personalizacaoDeProduto;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="produto_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "categoria", "foto"})
    private Produto produto;
    @Column(name="descricao")
    @Size(max=100)
    private @Size(max=100) String descricao;
    @Column(name="valor", length=8, precision=2)
    private BigDecimal valor;
    @Column(name="excluido")
    private Boolean excluido;
    @Column(name="em_falta")
    private Boolean emFalta;
    @Column(name="estoque")
    private Double estoque;
    @Column(name="ind_estoque_ilimitado")
    private Boolean estoqueIlimitado;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Personalizacao getPersonalizacao() {
        return this.personalizacao;
    }

    public void setPersonalizacao(Personalizacao personalizacao) {
        this.personalizacao = personalizacao;
    }

    public PersonalizacaoDeProduto getPersonalizacaoDeProduto() {
        return this.personalizacaoDeProduto;
    }

    public void setPersonalizacaoDeProduto(PersonalizacaoDeProduto personalizacaoDeProduto) {
        this.personalizacaoDeProduto = personalizacaoDeProduto;
    }

    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public Boolean getExcluido() {
        return this.excluido;
    }

    public void setExcluido(Boolean indAtivo) {
        this.excluido = indAtivo;
    }

    public Boolean getEmFalta() {
        return this.emFalta;
    }

    public void setEmFalta(Boolean emFalta) {
        this.emFalta = emFalta;
    }

    public Double getEstoque() {
        return this.estoque;
    }

    public void setEstoque(Double estoque) {
        this.estoque = estoque;
    }

    public Boolean getEstoqueIlimitado() {
        return this.estoqueIlimitado;
    }

    public void setEstoqueIlimitado(Boolean estoqueIlimitado) {
        this.estoqueIlimitado = estoqueIlimitado;
    }
}

