/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="enderecos_entrega")
@SequenceGenerator(name="enderecos_entrega_gen", sequenceName="enderecos_entrega_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EnderecoDeEntrega
implements Serializable {
    private static final long serialVersionUID = -4140824917079571081L;
    public static final String ENTITY_NAME = "Endere\u00e7o de Entrega";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="enderecos_entrega_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="municipio_id", referencedColumnName="id")
    private Municipio municipio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cliente_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "nome", "usuario", "telefone", "dataNascimento", "senha", "ativo", "enderecosDeEntrega", "cuponsUtilizados", "solicitacoesDeAtivacao", "pedidos", "cancelamentosDaConta"})
    private Cliente cliente;
    @Column(name="logradouro")
    private String logradouro;
    @Column(name="numero")
    private String numero;
    @Column(name="complemento")
    private String complemento;
    @Column(name="cep")
    private String cep;
    @Column(name="ponto_referencia")
    private String pontoDeReferencia;
    @Column(name="descricao")
    private String descricao;
    @Column(name="ind_principal")
    private Boolean enderecoPrincipal;
    @Column(name="bairro")
    private String bairro;
    @Column(name="ind_excluido")
    private Boolean excluido;

    public EnderecoDeEntrega() {
    }

    public EnderecoDeEntrega(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Municipio getMunicipio() {
        return this.municipio;
    }

    public void setMunicipio(Municipio municipio) {
        this.municipio = municipio;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getPontoDeReferencia() {
        return this.pontoDeReferencia;
    }

    public void setPontoDeReferencia(String pontoReferencia) {
        this.pontoDeReferencia = pontoReferencia;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Boolean getEnderecoPrincipal() {
        return this.enderecoPrincipal;
    }

    public void setEnderecoPrincipal(Boolean enderecoPrincipal) {
        this.enderecoPrincipal = enderecoPrincipal;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public Boolean getExcluido() {
        return this.excluido;
    }

    public void setExcluido(Boolean excluido) {
        this.excluido = excluido;
    }

    public String getEnderecoFormatado() {
        String enderecoFormatado = "%s, %s - %s - %s - %s/%s";
        return String.format(enderecoFormatado, this.logradouro, this.numero, this.bairro, StringUtil.formatarCEP((String)this.cep), this.municipio.getNome(), this.municipio.getUf());
    }

    public String getEnderecoNaoFormatado() {
        String enderecoFormatado = "%s %s - %s - %s - %s %s";
        return String.format(enderecoFormatado, StringUtil.removerAcentos((String)this.logradouro), this.numero, StringUtil.removerAcentos((String)this.bairro), this.cep, StringUtil.removerAcentos((String)this.municipio.getNome()), this.municipio.getUf());
    }
}

