/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="cashbacks")
@SequenceGenerator(name="cashbacks_gen", sequenceName="cashbacks_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Cashback
implements Serializable {
    private static final long serialVersionUID = 2426460703289423760L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="cashbacks_gen")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cliente_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "cpf", "dataCadastro", "dataNascimento", "dataHoraAtualizacao", "ativo", "enderecosDeEntrega"})
    private Cliente cliente;
    @Temporal(value=TemporalType.DATE)
    @Column(name="dt_inicio_utilizacao")
    private Date dataDeInicioDaUtilizacao;
    @Column(name="credito_disponivel")
    private BigDecimal creditoDisponivel;
    @Column(name="credito_utilizado")
    private BigDecimal creditoUtilizado;
    @Column(name="credito_reservado")
    private BigDecimal creditoReservado;
    @Column(name="ind_ativo")
    private Boolean ativo;
    @Transient
    private String justificativaDeAlteracao;
    @Transient
    private BigDecimal valorAjustado;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public Date getDataDeInicioDaUtilizacao() {
        return this.dataDeInicioDaUtilizacao;
    }

    public void setDataDeInicioDaUtilizacao(Date dataDeInicioDaUtilizacao) {
        this.dataDeInicioDaUtilizacao = dataDeInicioDaUtilizacao;
    }

    public BigDecimal getCreditoDisponivel() {
        return this.creditoDisponivel;
    }

    public void setCreditoDisponivel(BigDecimal creditoDisponivel) {
        this.creditoDisponivel = creditoDisponivel;
    }

    public BigDecimal getCreditoUtilizado() {
        return this.creditoUtilizado;
    }

    public void setCreditoUtilizado(BigDecimal creditoUtilizado) {
        this.creditoUtilizado = creditoUtilizado;
    }

    public BigDecimal getCreditoReservado() {
        return this.creditoReservado;
    }

    public void setCreditoReservado(BigDecimal creditoReservado) {
        this.creditoReservado = creditoReservado;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public String getJustificativaDeAlteracao() {
        return this.justificativaDeAlteracao;
    }

    public void setJustificativaDeAlteracao(String justificativaDeAlteracao) {
        this.justificativaDeAlteracao = justificativaDeAlteracao;
    }

    public BigDecimal getValorAjustado() {
        return this.valorAjustado;
    }

    public void setValorAjustado(BigDecimal valorAjustado) {
        this.valorAjustado = valorAjustado;
    }
}

