/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.enumeration;

import com.escolpi.omni.api.exception.ApiException;
import java.util.Arrays;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Brand {
    AMEX("Amex", "^3[47][0-9]{13}"),
    ELO("Elo", "^3(?:0[0-5]|[68][0-9])[0-9]{11}"),
    DINERS("Diners", "^6(?:011|5[0-9]{2})[0-9]{12}"),
    DISCOVER("Discover", "^(40117[8-9]|431274|438935|451416|457393|45763[1-2]|506(699|7[0-6][0-9]|77[0-8])|509\\d{3}|504175|627780|636297|636368|65003[1-3]|6500(3[5-9]|4[0-9]|5[0-1])|6504(0[5-9]|[1-3][0-9])|650(4[8-9][0-9]|5[0-2][0-9]|53[0-8])|6505(4[1-9]|[5-8][0-9]|9[0-8])|6507(0[0-9]|1[0-8])|65072[0-7]|6509(0[1-9]|1[0-9]|20)|6516(5[2-9]|[6-7][0-9])|6550([0-1][0-9]|2[1-9]|[3-4][0-9]|5[0-8]))"),
    HIPERCARD("Hipercard", "^(606282\\d{10}(\\d{3})?)|(3841\\d{15})"),
    JCB("JCB", "^(?:2131|1800|35\\d{3})\\d{11}"),
    MASTER("Master", "^5[1-5][0-9]{14}"),
    VISA("Visa", "^4[0-9]{12}(?:[0-9]{3})");

    private String descricao;
    private String regex;

    private Brand(String descricao, String regex) {
        this.descricao = descricao;
        this.regex = regex;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public static List<Brand> listarTodos() {
        return Arrays.asList(Brand.values());
    }

    public static Brand detectBrand(String creditCardNumber) throws ApiException {
        return Brand.listarTodos().stream().filter(brand -> creditCardNumber.matches(brand.getRegex())).findFirst().orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Bandeira"}));
    }
}

