/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.domain;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;

public class Message {
    private static Message instance;
    private PropertyResourceBundle bundle;

    public Message() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream resourceStream = loader.getResourceAsStream("i18n/messages_pt_BR.properties");){
            this.bundle = new PropertyResourceBundle(resourceStream);
        }
    }

    public static Message getInstance() {
        if (instance == null) {
            try {
                return new Message();
            }
            catch (Exception e) {
                return null;
            }
        }
        return instance;
    }

    public String getMessage(String messageKey) {
        return this.bundle.getString(messageKey);
    }

    public String getMessage(String chaveMensagem, String ... parametros) {
        return MessageFormat.format(this.bundle.getString(chaveMensagem), this.getParametros(parametros));
    }

    private Object[] getParametros(String ... parametros) {
        Object[] params = new Object[parametros.length];
        for (int i = 0; i < parametros.length; ++i) {
            params[i] = parametros[i];
        }
        return params;
    }
}

