/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.model.entity.TarifaDeEntregaExclusiva;
import com.escolpi.omni.api.model.specification.builder.TarifaDeEntregaExclusivaSpecificationBuilder;
import com.escolpi.omni.api.repository.MunicipioRepository;
import com.escolpi.omni.api.repository.TarifaDeEntregaExclusivaRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.List;
import javax.transaction.Transactional;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TarifaDeEntregaExclusivaService
implements BaseCrudService<TarifaDeEntregaExclusiva, Long> {
    @Autowired
    private TarifaDeEntregaExclusivaRepository repository;
    @Autowired
    private MunicipioRepository cityRepository;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            this.repository.deleteById((Object)id);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            throw new ApiException("msg.erro.048", new String[]{"Tarifa de Entrega Exclusiva", "Pedido"});
        }
    }

    public Page<TarifaDeEntregaExclusiva> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        TarifaDeEntregaExclusivaSpecificationBuilder builder = new TarifaDeEntregaExclusivaSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<TarifaDeEntregaExclusiva> findAll(Long empresaId) throws ApiException {
        return this.repository.findAll();
    }

    public TarifaDeEntregaExclusiva findById(Long id) throws ApiException {
        return (TarifaDeEntregaExclusiva)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Tarifa de Entrega Exclusiva", id.toString()}));
    }

    public TarifaDeEntregaExclusiva findActiveExclusiveFee(Long companyId, String cep, Long cityId) throws ApiException {
        return this.repository.findActiveExclusiveFee(companyId, cep, cityId).orElse(null);
    }

    @Transactional
    public void save(TarifaDeEntregaExclusiva entity) throws ApiException {
        this.validate(entity);
        if (NullUtil.isNotNullOrZero((Number)entity.getId())) {
            this.repository.save((Object)this.populateEntity(entity));
            return;
        }
        entity.setMunicipio((Municipio)this.cityRepository.findByIbgeId(entity.getMunicipio().getIbgeId()).get());
        this.repository.save((Object)entity);
    }

    public void validate(TarifaDeEntregaExclusiva entity) throws ApiException {
        if (NullUtil.isNull((Object)entity)) {
            throw new ApiException("msg.erro.001", new String[]{"Tarifa de Entrega Exclusiva"});
        }
        if (NullUtil.isNull((Object)entity.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (!StringUtils.hasText((String)entity.getDescricao())) {
            throw new ApiException("msg.erro.001", new String[]{"Descri\u00e7\u00e3o"});
        }
        if (!StringUtils.hasText((String)entity.getCep())) {
            throw new ApiException("msg.erro.001", new String[]{"CEP"});
        }
        if (!NullUtil.isNotNull((Object)entity.getMunicipio()) || !NullUtil.isNotNull((Object)entity.getMunicipio().getIbgeId())) {
            throw new ApiException("msg.erro.172");
        }
        if (!StringUtils.hasText((String)entity.getLogradouro())) {
            throw new ApiException("msg.erro.001", new String[]{"Logradouro"});
        }
        if (!StringUtils.hasText((String)entity.getNumero())) {
            throw new ApiException("msg.erro.001", new String[]{"N\u00famero"});
        }
        if (!NullUtil.isNotNull((Object)entity.getBairro())) {
            throw new ApiException("msg.erro.001", new String[]{"Bairro"});
        }
        if (!NullUtil.isNotNull((Object)entity.getValor())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor"});
        }
        if (!NullUtil.isNotNull((Object)entity.getMunicipio().getUf())) {
            throw new ApiException("msg.erro.001", new String[]{"Estado"});
        }
    }

    private TarifaDeEntregaExclusiva populateEntity(TarifaDeEntregaExclusiva entity) throws ApiException {
        TarifaDeEntregaExclusiva edit = this.findById(entity.getId());
        edit.setEmpresa(entity.getEmpresa());
        edit.setMunicipio((Municipio)this.cityRepository.findByIbgeId(entity.getMunicipio().getIbgeId()).get());
        edit.setDescricao(entity.getDescricao());
        edit.setCep(entity.getCep());
        edit.setLogradouro(entity.getLogradouro());
        edit.setNumero(entity.getNumero());
        edit.setBairro(entity.getBairro());
        edit.setComplemento(entity.getComplemento());
        edit.setValor(entity.getValor());
        edit.setAtivo(entity.getAtivo());
        return edit;
    }
}

