/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.Promocao;
import com.escolpi.omni.api.model.entity.PromocaoBrinde;
import com.escolpi.omni.api.model.entity.PromocaoRegraDeCompra;
import com.escolpi.omni.api.model.specification.builder.PromocaoSpecificationBuilder;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.repository.PromocaoBrindeRepository;
import com.escolpi.omni.api.repository.PromocaoRegraDeCompraRepository;
import com.escolpi.omni.api.repository.PromocaoRepository;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.FileUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PromocaoService
implements BaseCrudService<Promocao, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromocaoService.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private PromocaoRepository repository;
    @Autowired
    private PromocaoRegraDeCompraRepository regraDeCompraRepository;
    @Autowired
    private PromocaoBrindeRepository brindeRepository;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            List regras = this.regraDeCompraRepository.findByPromocaoId(id);
            for (PromocaoRegraDeCompra regra : regras) {
                List brindes = this.brindeRepository.findByRegraId(regra.getId());
                brindes.forEach(brinde -> this.brindeRepository.delete(brinde));
                this.regraDeCompraRepository.delete((Object)regra);
            }
            Promocao edicao = this.findById(id);
            edicao.setExcluida(Boolean.valueOf(true));
            this.repository.save((Object)edicao);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            throw new ApiException("msg.erro.048", new String[]{"Promo\u00e7\u00e3o", "Pedido"});
        }
    }

    public Page<Promocao> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        PromocaoSpecificationBuilder builder = new PromocaoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("titulo"), (String)"asc");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<Promocao> findAll(Long empresaId) throws ApiException {
        return this.repository.findByEmpresaIdAndExcluidaIsFalse(empresaId);
    }

    @Deprecated
    public List<Promocao> getPromotionCatalogList(Long empresaId) throws ApiException {
        ArrayList<Promocao> catalog = new ArrayList<Promocao>();
        List avaliablePromotions = this.repository.findPromocoesVigentes(empresaId, DateUtil.obterDiaDaSemanaCorrente().ordinal() + "");
        for (Promocao promotion : avaliablePromotions) {
            if (!this.validatePromotionRules(promotion)) continue;
            if (StringUtil.isNotBlank((String)promotion.getCaminhoFoto())) {
                promotion.setMiniatura(this.fileService.getPictureUrl(promotion, true));
            }
            Promocao catalogItem = new Promocao();
            catalogItem.setId(promotion.getId());
            catalogItem.setTitulo(promotion.getTitulo());
            catalogItem.setDescricao(promotion.getDescricao());
            catalogItem.setFotoExterna(promotion.getFotoExterna());
            if (catalogItem.getFotoExterna().booleanValue()) {
                catalogItem.setMiniatura(promotion.getCaminhoFoto());
            } else {
                catalogItem.setMiniatura(this.fileService.getPictureUrl(promotion, true));
            }
            catalogItem.setValorFixo(promotion.getValorFixo());
            catalog.add(catalogItem);
        }
        return catalog;
    }

    public Promocao getSelectedPromotionFromCatalog(Long empresaId, Long promocaoId) throws ApiException {
        Promocao promotion = (Promocao)this.repository.findById((Object)promocaoId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Promo\u00e7\u00e3o", promocaoId.toString()}));
        Promocao catalogItem = new Promocao();
        catalogItem.setId(promotion.getId());
        catalogItem.setTitulo(promotion.getTitulo());
        catalogItem.setDescricao(promotion.getDescricao());
        catalogItem.setCaminhoFoto(promotion.getCaminhoFoto());
        catalogItem.setValorFixo(promotion.getValorFixo());
        catalogItem.setMiniatura(this.fileService.getPictureUrl(promotion, true));
        catalogItem.setRegrasDeCompra(new HashSet());
        promotion.getRegrasDeCompra().forEach(rule -> {
            PromocaoRegraDeCompra catalogRule = new PromocaoRegraDeCompra();
            catalogRule.setId(rule.getId());
            catalogRule.setDescricao(rule.getDescricao());
            catalogRule.setOpcional(rule.getOpcional());
            catalogRule.setSemComposicao(rule.getSemComposicao());
            catalogRule.setPromocao(new Promocao(rule.getPromocao().getId()));
            catalogItem.getRegrasDeCompra().add(catalogRule);
        });
        return catalogItem;
    }

    public Promocao findById(Long id) throws ApiException {
        return (Promocao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Promo\u00e7\u00e3o", id.toString()}));
    }

    public Promocao findById(Long id, Long empresaId) throws ApiException {
        Promocao promotion = (Promocao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Promo\u00e7\u00e3o", id.toString()}));
        if (!promotion.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculada", new String[]{Entidade.PROMOCAO.getDescricao()});
        }
        return promotion;
    }

    public Promocao findActivePromotionById(Long id) throws ApiException {
        Promocao promotion = (Promocao)this.repository.findPromocaoVigenteById(id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Promo\u00e7\u00e3o", id.toString()}));
        if (StringUtil.isNotBlank((String)promotion.getCaminhoFoto())) {
            promotion.setFoto(this.fileService.getPictureUrl(promotion, false));
            promotion.setMiniatura(this.fileService.getPictureUrl(promotion, true));
        }
        promotion.getRegrasDeCompra().forEach(rule -> {
            if (!this.isRuleGroupedByCategory(rule)) {
                rule.getBrindes().stream().map(gift -> gift.getProduto()).forEach(product -> {
                    try {
                        if (StringUtil.isNotBlank((String)product.getCaminhoFoto())) {
                            product.setMiniatura(product.getFotoExterna() != false ? product.getCaminhoFoto() : this.fileService.getPictureUrl(product, true));
                        } else {
                            product.setMiniatura(this.fileService.getPictureUrl(product.getCategoria().getEmblema()));
                        }
                    }
                    catch (ApiException e) {
                        LOGGER.error(e.getMessage());
                    }
                });
            }
        });
        return promotion;
    }

    public Promocao findFullById(Long id) throws ApiException {
        Promocao promocao = (Promocao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Promo\u00e7\u00e3o", id.toString()}));
        if (StringUtil.isNotBlank((String)promocao.getCaminhoFoto())) {
            promocao.setFoto(this.fileService.getPictureUrl(promocao, false));
        }
        promocao.setRegrasDeCompra(new HashSet(this.regraDeCompraRepository.findByPromocaoId(promocao.getId())));
        for (PromocaoRegraDeCompra regra : promocao.getRegrasDeCompra()) {
            regra.setBrindes(new HashSet(this.brindeRepository.findByRegraId(regra.getId())));
        }
        return promocao;
    }

    @Transactional
    public void save(Promocao promotion) throws ApiException {
        this.validate(promotion);
        String path = this.getPromotionPath(promotion.getEmpresa().getId()) + File.separator;
        if (NullUtil.isNotNullOrZero((Number)promotion.getId())) {
            Promocao edicao = (Promocao)this.repository.findById((Object)promotion.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Promo\u00e7\u00e3o", promotion.getId().toString()}));
            edicao.setTitulo(promotion.getTitulo());
            edicao.setDescricao(promotion.getDescricao());
            edicao.setDisponibilidades(promotion.getDisponibilidades());
            edicao.setDtInicioValidade(promotion.getDtInicioValidade());
            edicao.setDtFimValidade(promotion.getDtFimValidade());
            edicao.setAceitaCupomDeDesconto(promotion.getAceitaCupomDeDesconto());
            edicao.setValorFixo(promotion.getValorFixo());
            edicao.setAtivo(promotion.getAtivo());
            edicao.setRegrasDeCompra(promotion.getRegrasDeCompra());
            edicao.setFotoExterna(promotion.getFotoExterna());
            if (edicao.getFotoExterna().booleanValue()) {
                edicao.setCaminhoFoto(promotion.getCaminhoFoto());
            } else if (StringUtil.isNotBlank((String)edicao.getCaminhoFoto()) && StringUtil.isNotBlank((String)promotion.getCaminhoFoto())) {
                String caminhoAtual = this.getPromotionPath(edicao.getEmpresa().getId()) + File.separator + edicao.getCaminhoFoto();
                String caminhoMiniaturaAtual = this.getPromotionPath(edicao.getEmpresa().getId()) + File.separator + "_" + edicao.getCaminhoFoto();
                if (FileUtil.fileExists((String)caminhoAtual)) {
                    FileUtil.deleteFile((String)caminhoAtual);
                }
                if (FileUtil.fileExists((String)caminhoMiniaturaAtual)) {
                    FileUtil.deleteFile((String)caminhoMiniaturaAtual);
                }
                edicao.setCaminhoFoto(this.generatePictureName(promotion));
                path = path + edicao.getCaminhoFoto();
                this.fileService.saveBase64File(path, promotion.getFoto());
                this.fileService.saveThumbnailFile(path, promotion.getFoto(), 640);
            }
            this.savePromotionRules(edicao);
            this.repository.save((Object)edicao);
        } else {
            promotion.setExcluida(Boolean.valueOf(false));
            this.repository.save((Object)promotion);
            this.savePromotionRules(promotion);
            if (StringUtil.isNotBlank((String)promotion.getFoto())) {
                promotion.setCaminhoFoto(this.generatePictureName(promotion));
                path = path + promotion.getCaminhoFoto();
                this.fileService.saveBase64File(path, promotion.getFoto());
                this.fileService.saveThumbnailFile(path, promotion.getFoto(), 640);
                this.repository.save((Object)promotion);
            }
        }
    }

    @Transactional
    public void toggleActivation(Long id) throws ApiException {
        Promocao promocao;
        promocao.setAtivo(Boolean.valueOf((promocao = this.findById(id)).getAtivo() == false));
        this.repository.save((Object)promocao);
    }

    public void validate(Promocao promotion) throws ApiException {
        if (StringUtil.isBlank((String)promotion.getTitulo())) {
            throw new ApiException("msg.erro.001", new String[]{"T\u00edtulo"});
        }
        if (StringUtil.isBlank((String)promotion.getDisponibilidades())) {
            throw new ApiException("msg.erro.001", new String[]{"Promo\u00e7\u00e3o dispon\u00edvel nos dias"});
        }
        if (NullUtil.isNull((Object)promotion.getDtInicioValidade())) {
            throw new ApiException("msg.erro.001", new String[]{"Data inicial de validade da Promo\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)promotion.getDtFimValidade())) {
            throw new ApiException("msg.erro.001", new String[]{"Data final de validade da Promo\u00e7\u00e3o"});
        }
        if (DateUtil.isPassado((Date)promotion.getDtFimValidade()).booleanValue()) {
            throw new ApiException("msg.erro.069", new String[]{"Data final de validade da Promo\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)promotion.getAceitaCupomDeDesconto())) {
            throw new ApiException("msg.erro.001", new String[]{"Aceita cupom de desconto?"});
        }
        if (NullUtil.isNullOrZero((Number)promotion.getId()) && NullUtil.isNull((Object)promotion.getCaminhoFoto())) {
            throw new ApiException("msg.erro.001", new String[]{"Foto"});
        }
        if (CollectionUtils.isEmpty((Collection)promotion.getRegrasDeCompra())) {
            throw new ApiException("msg.erro.075");
        }
        for (PromocaoRegraDeCompra regra : promotion.getRegrasDeCompra()) {
            if (!CollectionUtils.isEmpty((Collection)regra.getBrindes())) continue;
            throw new ApiException("msg.erro.072");
        }
        List promocoes = this.repository.findByEmpresaIdAndExcluidaIsFalse(promotion.getEmpresa().getId());
        List promocoesExistentes = promocoes.stream().filter(item -> !item.getId().equals(promotion.getId()) && item.getTitulo().equals(promotion.getTitulo()) && DateUtil.isMesmaData((Date)item.getDtInicioValidade(), (Date)promotion.getDtInicioValidade()) != false && DateUtil.isMesmaData((Date)item.getDtFimValidade(), (Date)promotion.getDtFimValidade()) != false).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(promocoesExistentes)) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Promo\u00e7\u00e3o"});
        }
    }

    private boolean validatePromotionRules(Promocao promotion) {
        for (PromocaoRegraDeCompra rule : promotion.getRegrasDeCompra()) {
            if (rule.getCategoria().getExcluida().booleanValue() || !rule.getCategoria().getAtivo().booleanValue()) {
                return false;
            }
            for (PromocaoBrinde gift : rule.getBrindes()) {
                if (NullUtil.isNotNull((Object)gift.getProduto())) {
                    if (gift.getProduto().getExcluido().booleanValue() || !gift.getProduto().getEmFalta().booleanValue()) continue;
                    return false;
                }
                List giftProducts = this.produtoRepository.findByEmpresaIdAndCategoriaIdAndExcluidoIsFalseOrderByNome(promotion.getEmpresa().getId(), gift.getCategoria().getId());
                if (CollectionUtils.isEmpty((Collection)giftProducts)) {
                    return false;
                }
                for (Produto product : giftProducts) {
                    if (!product.getEmFalta().booleanValue() && !product.getExcluido().booleanValue()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private String generatePictureName(Promocao sale) {
        if (StringUtil.isNotBlank((String)sale.getFoto()) && StringUtil.isNotBlank((String)sale.getCaminhoFoto())) {
            return DateUtil.format((String)"yyyyMMdd", (Date)new Date()) + "_" + sale.getId() + StringUtil.obterExtensao((String)sale.getCaminhoFoto());
        }
        return null;
    }

    private String getPromotionPath(Long empresaId) throws ApiException {
        return this.fileService.getCompanyGaleryPath(empresaId, "promocoes");
    }

    public boolean isRuleGroupedByCategory(PromocaoRegraDeCompra rule) {
        return NullUtil.isNotNull((Object)rule.getCategoria()) && rule.getBrindes().size() == 1;
    }

    @Transactional
    private void savePromotionRules(Promocao sale) throws ApiException {
        Set<Long> regras = this.regraDeCompraRepository.findByPromocaoId(sale.getId()).stream().map(regra -> regra.getId()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(regras)) {
            for (PromocaoRegraDeCompra regra2 : sale.getRegrasDeCompra()) {
                regra2.setPromocao(sale);
                if (NullUtil.isNull((Object)regra2.getOpcional())) {
                    regra2.setOpcional(Boolean.valueOf(false));
                }
                this.regraDeCompraRepository.save((Object)regra2);
                this.savePromotionGifts(regra2);
            }
        } else {
            if (sale.getRegrasDeCompra().stream().filter(regra -> NullUtil.isNullOrZero((Number)regra.getId())).count() == (long)sale.getRegrasDeCompra().size()) {
                regras.forEach(regraId -> {
                    this.brindeRepository.findByRegraId(regraId).forEach(brinde -> this.brindeRepository.delete(brinde));
                    this.regraDeCompraRepository.deleteById(regraId);
                });
            } else {
                Set<Long> listaExclusao = regras.stream().filter(regra -> !sale.getRegrasDeCompra().stream().map(rule -> rule.getId()).collect(Collectors.toSet()).contains(regra)).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(listaExclusao)) {
                    listaExclusao.forEach(regraId -> {
                        if (NullUtil.isNotNullOrZero((Number)regraId)) {
                            this.brindeRepository.findByRegraId(regraId).forEach(brinde -> this.brindeRepository.delete(brinde));
                            this.regraDeCompraRepository.deleteById(regraId);
                        }
                    });
                }
            }
            for (PromocaoRegraDeCompra regra3 : sale.getRegrasDeCompra()) {
                regra3.setPromocao(sale);
                if (NullUtil.isNotNullOrZero((Number)regra3.getId())) {
                    PromocaoRegraDeCompra edicao = (PromocaoRegraDeCompra)this.regraDeCompraRepository.findById((Object)regra3.getId()).get();
                    edicao.setCategoria(regra3.getCategoria());
                    edicao.setOpcional(regra3.getOpcional());
                    edicao.setSemComposicao(regra3.getSemComposicao());
                    edicao.setVenderPorTamanho(regra3.getVenderPorTamanho());
                    edicao.setTamanhos(regra3.getTamanhos());
                    edicao.setQtdeMaxBrindes(regra3.getQtdeMaxBrindes());
                    edicao.setTipoRegra(regra3.getTipoRegra());
                }
                this.regraDeCompraRepository.save((Object)regra3);
                this.savePromotionGifts(regra3);
            }
        }
    }

    @Transactional
    private void savePromotionGifts(PromocaoRegraDeCompra rule) throws ApiException {
        Set giftList = this.brindeRepository.findByRegraId(rule.getId()).stream().map(brinde -> brinde.getId()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(giftList)) {
            rule.getBrindes().forEach(brinde -> {
                brinde.setRegra(rule);
                this.brindeRepository.save(brinde);
            });
        } else {
            Set<Long> listaExclusao = giftList.stream().filter(id -> !rule.getBrindes().stream().map(gift -> gift.getId()).collect(Collectors.toSet()).contains(id)).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(listaExclusao)) {
                listaExclusao.forEach(brindeId -> {
                    if (NullUtil.isNotNullOrZero((Number)brindeId)) {
                        this.brindeRepository.deleteById(brindeId);
                    }
                });
            }
            rule.getBrindes().forEach(brinde -> {
                if (NullUtil.isNotNullOrZero((Number)brinde.getId())) {
                    PromocaoBrinde edicao = (PromocaoBrinde)this.brindeRepository.findById((Object)brinde.getId()).get();
                    edicao.setCategoria(brinde.getCategoria());
                    edicao.setGratuito(brinde.getGratuito());
                    edicao.setProduto(brinde.getProduto());
                    brinde.setRegra(rule);
                    if (NullUtil.isNotNullOrZero((BigDecimal)brinde.getValor())) {
                        edicao.setValor(brinde.getValor().setScale(2, RoundingMode.UNNECESSARY));
                    } else {
                        edicao.setValor(null);
                    }
                    this.brindeRepository.save((Object)edicao);
                } else {
                    brinde.setRegra(rule);
                    this.brindeRepository.save(brinde);
                }
            });
        }
    }
}

