/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Plano;
import com.escolpi.omni.api.model.entity.dto.DataOption;
import com.escolpi.omni.api.repository.PlanoRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlanoService {
    @Autowired
    private PlanoRepository repository;

    public List<Plano> findAll() {
        return this.repository.findAll();
    }

    public List<Plano> findAllActivePlans() {
        return this.repository.findByAtivoIsTrue();
    }

    public Plano findById(Long id) throws ApiException {
        return (Plano)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Plano", id.toString()}));
    }

    public List<DataOption> listPlanOptions() {
        return this.repository.findByAtivoIsTrue().stream().map(arg_0 -> this.parseDataOption(arg_0)).collect(Collectors.toList());
    }

    private DataOption parseDataOption(Plano plan) {
        return new DataOption(plan.getNome(), plan.getId());
    }
}

