/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.PersonalizacaoDeProduto;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.model.specification.builder.PersonalizacaoDeProdutoSpecificationBuilder;
import com.escolpi.omni.api.repository.PersonalizacaoDeProdutoRepository;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.repository.ValorDaPersonalizacaoRepository;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PersonalizacaoDeProdutoService
implements BaseCrudResource<PersonalizacaoDeProduto, Long> {
    @Autowired
    private PersonalizacaoDeProdutoRepository repository;
    @Autowired
    private ProdutoRepository productRepository;
    @Autowired
    private ValorDaPersonalizacaoRepository valueRepository;

    public PersonalizacaoDeProduto findById(Long id) throws ApiException {
        PersonalizacaoDeProduto customization = (PersonalizacaoDeProduto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Personaliza\u00e7\u00e3o", id.toString()}));
        customization.setValoresDaPersonalizacao(customization.getValoresDaPersonalizacao().stream().filter(value -> value.getExcluido() == false).collect(Collectors.toSet()));
        return customization;
    }

    public List<PersonalizacaoDeProduto> findByProductIdToCatalog(Long productId) throws ApiException {
        List customizations = this.repository.findByProdutoIdAndExcluidoIsFalseOrderByOrdem(productId);
        customizations.stream().forEach(customization -> {
            Set activeValues = customization.getValoresDaPersonalizacao().stream().filter(value -> value.getExcluido() == false && value.getEmFalta() == false).collect(Collectors.toSet());
            customization.setValoresDaPersonalizacao(activeValues);
        });
        return customizations;
    }

    public List<ValorDaPersonalizacao> findByProductCustomizationIdToCatalog(Long productCustomizationId) {
        return this.valueRepository.findByPersonalizacaoDeProdutoIdAndExcluidoIsFalseAndEmFaltaIsFalse(productCustomizationId);
    }

    @Transactional
    public void delete(Long empresaId, Long id) throws ApiException {
        PersonalizacaoDeProduto delete = this.findById(id);
        delete.setExcluido(Boolean.TRUE);
        delete.getValoresDaPersonalizacao().forEach(valor -> valor.setExcluido(Boolean.TRUE));
        this.repository.save((Object)delete);
    }

    public Page<PersonalizacaoDeProduto> filter(Long companyId, String search, Integer pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        PersonalizacaoDeProdutoSpecificationBuilder builder = new PersonalizacaoDeProdutoSpecificationBuilder(search);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page datasource = this.repository.findAll(spec, (Pageable)pageable);
        return datasource;
    }

    public PersonalizacaoDeProduto get(Long empresaId, Long id) throws ApiException {
        return (PersonalizacaoDeProduto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Personaliza\u00e7\u00e3o de Produto", id.toString()}));
    }

    public List<PersonalizacaoDeProduto> list(Long empresaId) throws ApiException {
        return null;
    }

    @Transactional
    public void save(Long empresaId, PersonalizacaoDeProduto customization) throws ApiException {
        this.validate(customization);
        if (NullUtil.isNotNullOrZero((Number)customization.getId())) {
            PersonalizacaoDeProduto edit = this.populateCustomizationProduct(customization);
            this.repository.save((Object)edit);
            edit.setValoresDaPersonalizacao(customization.getValoresDaPersonalizacao());
            this.saveCustomizationValues(edit);
        } else {
            this.repository.save((Object)customization);
            this.saveCustomizationValues(customization);
        }
    }

    public void validate(PersonalizacaoDeProduto entity) throws ApiException {
        if (StringUtil.isBlank((String)entity.getDescricao())) {
            throw new ApiException("msg.erro.001", new String[]{"Descri\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)entity.getMultiOpcional())) {
            throw new ApiException("msg.erro.001", new String[]{"Permite Selecionar mais de uma op\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)entity.getExcluido())) {
            throw new ApiException("msg.erro.001", new String[]{"Exclu\u00eddo"});
        }
        if (CollectionUtils.isEmpty((Collection)entity.getValoresDaPersonalizacao())) {
            throw new ApiException(entity.getMultiOpcional() == false ? "msg.erro.042" : "msg.erro.041");
        }
    }

    public void update(Long empresaId, PersonalizacaoDeProduto entity) throws ApiException {
    }

    @Transactional
    private void saveCustomizationValues(PersonalizacaoDeProduto customization) {
        List currentValues = this.valueRepository.findByPersonalizacaoDeProdutoIdAndExcluidoIsFalseOrderByDescricaoAsc(customization.getId()).stream().map(value -> value.getId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentValues)) {
            customization.getValoresDaPersonalizacao().forEach(value -> {
                value.setPersonalizacaoDeProduto(customization);
                value.setExcluido(Boolean.valueOf(false));
                this.valueRepository.save(value);
            });
        } else {
            Set<Object> removeEntries = new HashSet();
            Set ids = customization.getValoresDaPersonalizacao().stream().filter(value -> NullUtil.isNotNullOrZero((Number)value.getId())).map(value -> value.getId()).collect(Collectors.toSet());
            removeEntries = currentValues.stream().filter(id -> !ids.contains(id)).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(removeEntries)) {
                removeEntries.forEach(valueId -> {
                    ValorDaPersonalizacao value = (ValorDaPersonalizacao)this.valueRepository.findById(valueId).get();
                    value.setExcluido(Boolean.valueOf(true));
                    this.valueRepository.save((Object)value);
                });
            }
            customization.getValoresDaPersonalizacao().forEach(value -> {
                if (NullUtil.isNull((Object)value.getPersonalizacao())) {
                    value.setPersonalizacaoDeProduto(customization);
                    value.setExcluido(Boolean.valueOf(false));
                }
                this.valueRepository.save(value);
            });
        }
    }

    private PersonalizacaoDeProduto populateCustomizationProduct(PersonalizacaoDeProduto customization) throws ApiException {
        PersonalizacaoDeProduto edit = (PersonalizacaoDeProduto)this.repository.findById((Object)customization.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Personaliza\u00e7\u00e3o de Produto", customization.getId().toString()}));
        edit.setDescricao(customization.getDescricao());
        edit.setExcluido(NullUtil.isNotNull((Object)customization.getExcluido()) ? customization.getExcluido() : Boolean.FALSE);
        edit.setMultiOpcional(customization.getMultiOpcional());
        edit.setObrigatorio(NullUtil.isNotNull((Object)customization.getObrigatorio()) ? customization.getObrigatorio() : Boolean.FALSE);
        edit.setOrdem(customization.getOrdem());
        edit.setProduto((Produto)this.productRepository.findById((Object)customization.getProduto().getId()).get());
        edit.setQtdeMinimaPermitida(customization.getQtdeMinimaPermitida());
        edit.setQtdePermitida(customization.getQtdePermitida());
        edit.setQuantitativa(Boolean.valueOf(NullUtil.isNotNull((Object)customization.getQuantitativa()) ? customization.getQuantitativa() : false));
        edit.setQuantidadeMinima(customization.getQuantidadeMinima());
        edit.setQuantidadeMaxima(customization.getQuantidadeMaxima());
        edit.setQuantidadeMaximaDeOpcoes(customization.getQuantidadeMaximaDeOpcoes());
        return edit;
    }
}

