/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.MunicipioAtendido;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.MunicipioAtendidoRepository;
import com.escolpi.omni.api.util.NullUtil;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MunicipioAtendidoService {
    @Autowired
    private MunicipioAtendidoRepository repository;
    @Autowired
    private EmpresaRepository companyRepository;

    public MunicipioAtendido findByEmpresaIdAndMunicipioId(Long empresaId, Long municipioId) {
        return this.repository.findByEmpresaIdAndMunicipioIdAndAtivoIsTrue(empresaId, municipioId);
    }

    @Transactional
    public void saveAttendedCity(MunicipioAtendido attendedCity) throws ApiException {
        attendedCity.setTaxaDeEntrega(NullUtil.isNotNull((Object)attendedCity.getTaxaDeEntrega()) ? attendedCity.getTaxaDeEntrega() : BigDecimal.ZERO);
        attendedCity.setTaxaDeEntregaGratis(NullUtil.isNotNull((Object)attendedCity.getTaxaDeEntregaGratis()) ? attendedCity.getTaxaDeEntregaGratis() : BigDecimal.ZERO);
        attendedCity.setEmpresa((Empresa)this.companyRepository.findById((Object)attendedCity.getEmpresa().getId()).get());
        attendedCity.setAtivo(Boolean.valueOf(true));
        this.repository.save((Object)attendedCity);
    }

    @Transactional
    public void updateValues(Long companyId, List<MunicipioAtendido> cities) throws ApiException {
        for (MunicipioAtendido city : cities) {
            MunicipioAtendido edit = (MunicipioAtendido)this.repository.findById((Object)city.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Munic\u00edpio Atendido", city.getId().toString()}));
            edit.setTaxaDeEntrega(NullUtil.isNotNull((Object)city.getTaxaDeEntrega()) ? city.getTaxaDeEntrega() : BigDecimal.ZERO);
            edit.setTaxaDeEntregaGratis(NullUtil.isNotNull((Object)city.getTaxaDeEntregaGratis()) ? city.getTaxaDeEntregaGratis() : BigDecimal.ZERO);
            edit.setAtivo(city.getAtivo());
            this.repository.save((Object)edit);
        }
    }
}

