/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.FormaDePagamento;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.enumeration.TipoCupomDesconto;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.entity.PersonalizacaoDeProduto;
import com.escolpi.omni.api.model.entity.SolicitacaoDeSenha;
import com.escolpi.omni.api.model.entity.dto.MensagemDto;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class MessengerService {
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private PedidoService orderService;

    @Async(value="messengerExecutor")
    public void sendOrderMessage(Pedido order) throws ApiException {
        Empresa company = this.companyService.findById(order.getEmpresa().getId());
        if (!order.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO) && !order.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO) && Boolean.TRUE.equals(company.getWhatsapp()) && StringUtil.isNotBlank((String)company.getAtosBotId())) {
            try {
                String content = this.getContent(order);
                String phone = Boolean.TRUE.equals(order.getClienteSemCadastro()) ? order.getTelefoneClienteSemCadastro() : order.getCliente().getTelefone();
                MensagemDto message = new MensagemDto();
                message.setNumeroWhatsapp(String.format("55%s", StringUtil.removerMascara((String)phone)));
                message.setAtosBotId(company.getAtosBotId());
                message.setConteudo(content);
                message.setServidor(company.getServidor());
                message.setRetorno(null);
                this.sendToMessenger(message);
            }
            catch (RestClientException e) {
                throw new ApiException("msg.erro.191", new String[]{e.getCause().getMessage()});
            }
        }
    }

    @Async(value="messengerExecutor")
    public void sendRequestCompanyPasswordValidationCode(SolicitacaoDeSenha request) throws ApiException {
        try {
            Empresa company = (Empresa)this.companyRepository.findByUsuarioId(request.getUsuario().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", "Usu\u00e1rio " + request.getUsuario().getId()}));
            StringBuilder content = new StringBuilder(String.format("Ol\u00e1, %s \ud83d\ude00!!! Informe o c\u00f3digo abaixo para redefinir sua senha:%n%n", request.getUsuario().getNome()));
            content.append(String.format("*%s*%n%n", request.getNumeroAutenticacao()));
            content.append("*Lembre-se:* O c\u00f3digo vai expirar em 24 horas. Redefina sua nova senha o quanto antes!");
            MensagemDto message = new MensagemDto();
            message.setNumeroWhatsapp(String.format("55%s", StringUtil.removerMascara((String)request.getUsuario().getTelefone())));
            message.setAtosBotId(company.getAtosBotId());
            message.setConteudo(content.toString());
            message.setServidor(company.getServidor());
            message.setRetorno(null);
            this.sendToMessenger(message);
        }
        catch (RestClientException e) {
            throw new ApiException("msg.erro.191", new String[]{e.getCause().getMessage()});
        }
    }

    @Async(value="messengerExecutor")
    public void sendRequestCustomerPasswordValidationCode(SolicitacaoDeSenha request, Long companyId) throws ApiException {
        try {
            Empresa company = this.companyService.findById(companyId);
            StringBuilder content = new StringBuilder(String.format("Ol\u00e1, %s \ud83d\ude00!!! Informe o c\u00f3digo abaixo para redefinir sua senha:%n%n", request.getUsuario().getNome()));
            content.append(String.format("*%s*%n%n", request.getNumeroAutenticacao()));
            content.append("*Lembre-se:* O c\u00f3digo vai expirar em 24 horas. Redefina sua nova senha o quanto antes!");
            MensagemDto message = new MensagemDto();
            message.setNumeroWhatsapp(String.format("55%s", StringUtil.removerMascara((String)request.getUsuario().getTelefone())));
            message.setAtosBotId(company.getAtosBotId());
            message.setConteudo(content.toString());
            message.setServidor(company.getServidor());
            message.setRetorno(null);
            this.sendToMessenger(message);
        }
        catch (RestClientException e) {
            throw new ApiException("msg.erro.191", new String[]{e.getCause().getMessage()});
        }
    }

    private String composeConfirmedOrder(Pedido order) throws ApiException {
        Empresa company = this.companyService.findById(order.getEmpresa().getId());
        StringBuilder template = new StringBuilder("*Pedido Confirmado*\n\n");
        template.append(String.format("Ol\u00e1 %s \ud83d\ude00!!!%nSeu pedido foi confirmado e encaminhado para preparo.%n%n", this.getCustomerName(order))).append(String.format("*Pedido:* N\u00ba %s%n", order.getId())).append(String.format("\ud83d\udef5 *Tipo:* %s%n", order.getFormaEntrega().getDescricao()));
        template.append(String.format("\u23f1\ufe0f *Tempo m\u00e9dio:* %s min.%n", order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY) ? company.getTempoDeEntrega() : company.getTempoDeRetirada()));
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            if (StringUtil.isNotBlank((String)order.getEnderecoDeEntregaClienteSemCadastro())) {
                template.append(String.format("\ud83c\udfe0 *End. de Entrega:* %s%n", order.getEnderecoDeEntregaClienteSemCadastro()));
            } else {
                template.append(String.format("\ud83c\udfe0 *End. de Entrega:* %s%n", order.getEnderecoEntrega().getEnderecoFormatado()));
            }
        }
        template.append("\n*Itens do Pedido*\n");
        this.renderOrderItems(order, template);
        this.renderPromotionBaskets(order, template);
        this.renderPaymentData(order, template);
        this.renderDiscountData(order, template);
        if (NullUtil.isNotNullOrZero((BigDecimal)order.getCreditoCashback())) {
            template.append(String.format("\ud83e\udd11 *Cashback aprovisionado:* +%s%n", StringUtil.formatarMoeda((Double)order.getCreditoCashback().doubleValue())));
        }
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            template.append(String.format("*Taxa de Entrega:* %s%n", NullUtil.isNotNullOrZero((BigDecimal)order.getTaxaDeEntrega()) ? StringUtil.formatarMoeda((Double)order.getTaxaDeEntrega().doubleValue()) : "Gr\u00e1tis"));
        }
        template.append(String.format("*Total do Pedido:* %s%n", StringUtil.formatarMoeda((Double)order.getTotalDoPedido().doubleValue()))).append("\nTe avisaremos sobre o andamento do seu pedido \ud83d\ude09!\n\n");
        this.renderFooter(template);
        return template.toString();
    }

    private String composePreparingOrder(Pedido order) {
        StringBuilder template = new StringBuilder("*Pedido em Preparo*\n\n").append(String.format("%s, ", this.getCustomerName(order)));
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            template.append(String.format("o seu pedido n\u00ba *%s* est\u00e1 em preparo e logo sair\u00e1 para entrega:%n", order.getId()));
        } else {
            template.append(String.format("o seu pedido n\u00ba *%s* est\u00e1 em preparo e logo estar\u00e1 pronto para retirar:%n", order.getId())).append("\nTe avisaremos sobre o andamento do seu pedido \ud83d\ude09!\n\n");
        }
        template.append(this.getOrderProgress(order));
        this.renderFooter(template);
        return template.toString();
    }

    private String composeReadyToDispatchOrder(Pedido order) {
        StringBuilder template = new StringBuilder("*Pedido em entrega*\n\n").append(String.format("Tudo pronto %s \ud83d\ude01!!!%n", this.getCustomerName(order))).append("Seu pedido saiu para entrega. Esteja atento, nosso entregador chegar\u00e1 em breve:\n").append(this.getOrderProgress(order)).append("\nNosso muito obrigado pela confian\u00e7a e prefer\u00eancia! \u263a\ufe0f\ud83d\ude4f\ud83c\udffb\n\n");
        this.renderFooter(template);
        return template.toString();
    }

    private String composeReadyToWithdrawOrder(Pedido order) {
        StringBuilder template = new StringBuilder("*Pedido aguardando retirada*\n\n").append(String.format("Tudo pronto %s \ud83d\ude01!!!%n", this.getCustomerName(order))).append("Te esperamos em nossa loja para retirar seu pedido:\n").append(this.getOrderProgress(order)).append(String.format("*Nosso endere\u00e7o:* %s%n", order.getEmpresa().getEndereco())).append("\nNosso muito obrigado pela confian\u00e7a e prefer\u00eancia! \u263a\ufe0f\ud83d\ude4f\ud83c\udffb\n\n");
        this.renderFooter(template);
        return template.toString();
    }

    private String composeCanceledOrder(Pedido order) {
        StringBuilder template = new StringBuilder("*Pedido Cancelado*\n").append(String.format("%s, que pena \ud83d\ude14!!! Seu pedido foi cancelado!%n", this.getCustomerName(order))).append(this.getOrderProgress(order));
        this.renderFooter(template);
        return template.toString();
    }

    private String getContent(Pedido order) throws ApiException {
        String content = "";
        if (order.getSituacao().equals((Object)SituacaoDoPedido.CONFIRMADO)) {
            content = this.composeConfirmedOrder(order);
        }
        if (order.getSituacao().equals((Object)SituacaoDoPedido.PEDIDO_EM_PREPARO)) {
            content = this.composePreparingOrder(order);
        }
        if (order.getSituacao().equals((Object)SituacaoDoPedido.SAIU_PARA_ENTREGA)) {
            content = this.composeReadyToDispatchOrder(order);
        }
        if (order.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_RETIRADA)) {
            content = this.composeReadyToWithdrawOrder(order);
        }
        if (order.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO)) {
            content = this.composeCanceledOrder(order);
        }
        content = content.replace("\\/g", "\\\\");
        return content;
    }

    private String getCustomerName(Pedido order) {
        return Boolean.TRUE.equals(order.getClienteSemCadastro()) ? StringUtil.getFirstName((String)order.getNomeClienteSemCadastro()) : StringUtil.getFirstName((String)order.getCliente().getNome());
    }

    private String getOrderProgress(Pedido order) {
        String destinationIcon;
        String startIcon = order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY) ? "\ud83c\udfec" : "\ud83c\udfe0";
        String movingIcon = order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY) ? "\ud83d\udef5" : "\ud83d\udeb6";
        String string = destinationIcon = order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY) ? "\ud83c\udfe0" : "\ud83c\udfec";
        if (order.getSituacao().equals((Object)SituacaoDoPedido.CONFIRMADO)) {
            return String.format("%n%s_________%s__%s%n%n", destinationIcon, movingIcon, startIcon);
        }
        if (order.getSituacao().equals((Object)SituacaoDoPedido.PEDIDO_EM_PREPARO)) {
            return String.format("%n%s______%s_____%s%n%n", destinationIcon, movingIcon, startIcon);
        }
        if (order.getSituacao().equals((Object)SituacaoDoPedido.SAIU_PARA_ENTREGA) || order.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_RETIRADA)) {
            return String.format("%n%s__%s_________%s%n%n", destinationIcon, movingIcon, startIcon);
        }
        return String.format("%n%s____________%s%n%n", "\u274c", startIcon);
    }

    private void renderByBasketItems(Pedido order, StringBuilder template) {
        order.getCestasDePromocao().forEach(basket -> {
            template.append(String.format("*%s*%n", basket.getPromocao().getDescricao()));
            if (StringUtil.isNotBlank((String)basket.getObservacoes())) {
                template.append(String.format("\ud83d\udcdd *Obs.:* %s%n", basket.getObservacoes()));
            }
            basket.getItens().forEach(item -> {
                if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                    item.getProdutoComposto().getProdutos().forEach(product -> {
                        int size = item.getProdutoComposto().getProdutos().size();
                        template.append(String.format("\u2705 *1/%s %s%n*", size, product.getNome()));
                    });
                    template.append(String.format("*Tamanho: %s", item.getProdutoComposto().getTamanho()));
                } else {
                    template.append(String.format("\u2705 %sx %s%n", item.getQuantidade(), item.getProduto().getNome()));
                }
                if (StringUtil.isNotBlank((String)item.getObservacoes())) {
                    template.append(String.format("\ud83d\udcdd *Obs.:* %s%n", item.getObservacoes()));
                }
                item.getGrupoPersonalizacoesDeProduto().forEach(group -> {
                    template.append(String.format("  \ud83d\udc49 %s %n", ((PersonalizacaoDeProduto)group.getPersonalizacao()).getDescricao()));
                    group.getOpcionais().forEach(optional -> template.append(String.format("    %sx %s%n", optional.getQuantidade(), optional.getDescricao())));
                });
                item.getGrupoPersonalizacoes().stream().forEach(group -> {
                    System.out.println(((Personalizacao)group.getPersonalizacao()).getDescricao());
                    template.append(String.format("  \ud83d\udc49 %s %n", ((Personalizacao)group.getPersonalizacao()).getDescricao()));
                    group.getOpcionais().forEach(optional -> template.append(String.format("    %sx %s%n", optional.getQuantidade(), optional.getDescricao())));
                });
            });
        });
    }

    private void renderByCommonItems(Pedido order, StringBuilder template) {
        order.getItensDoPedido().forEach(item -> {
            if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                item.getProdutoComposto().getProdutos().forEach(product -> {
                    int size = item.getProdutoComposto().getProdutos().size();
                    template.append(String.format("\u2705 1/%s %s%n", size, product.getNome()));
                });
                template.append(String.format("*Tamanho: %s%n", item.getProdutoComposto().getTamanho()));
            } else {
                template.append(String.format("\u2705 %sx %s%n", item.getQuantidade(), item.getProduto().getNome()));
            }
            if (StringUtil.isNotBlank((String)item.getObservacoes())) {
                template.append(String.format("  \ud83d\udcdd *Obs.:* %s%n", item.getObservacoes()));
            }
            if (!CollectionUtils.isEmpty((Collection)item.getGrupoPersonalizacoesDeProduto())) {
                item.getGrupoPersonalizacoesDeProduto().forEach(group -> {
                    template.append(String.format("  \ud83d\udc49 %s %n", ((PersonalizacaoDeProduto)group.getPersonalizacao()).getDescricao()));
                    group.getOpcionais().forEach(optional -> template.append(String.format("    %sx %s%n", optional.getQuantidade(), optional.getDescricao())));
                });
            }
            if (!CollectionUtils.isEmpty((Collection)item.getGrupoPersonalizacoes())) {
                item.getGrupoPersonalizacoes().stream().forEach(group -> {
                    template.append(String.format("  \ud83d\udc49 %s %n", ((Personalizacao)group.getPersonalizacao()).getDescricao()));
                    group.getOpcionais().forEach(optional -> template.append(String.format("    %sx %s%n", optional.getQuantidade(), optional.getDescricao())));
                });
            }
        });
    }

    private void renderDiscountData(Pedido order, StringBuilder template) {
        BigDecimal totalItems;
        BigDecimal discountsByTicket;
        if (order.getCupomDeDesconto() != null && (discountsByTicket = this.orderService.calculateTotalOrderByDiscountTicket(order, totalItems = order.getItensDoPedido().stream().map(item -> item.getValor()).reduce(BigDecimal.ZERO, (total, value) -> total.add((BigDecimal)value)), BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) >= 1) {
            String discountValue = order.getCupomDeDesconto().getTipoDesconto().equals((Object)TipoCupomDesconto.VALOR_FIXO) ? StringUtil.formatarMoeda((Double)order.getCupomDeDesconto().getValorDesconto()) : StringUtil.formatarDecimal((Double)order.getCupomDeDesconto().getValorDesconto());
            template.append(String.format("\ud83c\udf9f\ufe0f *Cupom de Desconto:* %s (-%s)%n", order.getCupomDeDesconto().getCodigo(), discountValue));
        }
        if (NullUtil.isNotNullOrZero((BigDecimal)order.getDebitoCashback())) {
            template.append(String.format("\ud83d\udcb0 *Desconto do Cashback:* -%s%n", StringUtil.formatarMoeda((Double)order.getDebitoCashback().doubleValue())));
        }
    }

    private void renderFooter(StringBuilder template) {
        template.append(String.format("\u00a9 %s Pedido Agora%n", LocalDate.now().getYear())).append("https://pedidoagora.com.br");
    }

    private void renderOrderItems(Pedido order, StringBuilder template) {
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            this.renderByCommonItems(order, template);
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            this.renderByBasketItems(order, template);
        }
        template.append("\n");
    }

    private void renderPaymentData(Pedido order, StringBuilder template) {
        if (order.getFormaPagamento() != null) {
            if (order.getFormaPagamento().equals((Object)FormaDePagamento.DINHEIRO)) {
                template.append("\ud83d\udcb5 *Pagamento em Dinheiro*\n");
                if (NullUtil.isNotNullOrZero((BigDecimal)order.getValorTroco())) {
                    template.append(String.format("*Troco para:* %s%n", StringUtil.formatarMoeda((Double)order.getValorTroco().doubleValue())));
                } else {
                    template.append("N\u00e3o precisa de troco\n");
                }
            } else if (order.getFormaPagamento().equals((Object)FormaDePagamento.MAQUINA_MOVEL)) {
                template.append(String.format("\ud83d\udcb3 *Pagamento com Cart\u00e3o:* %s%n", order.getOpcaoPagamentoCartao().getDescricao()));
            } else if (order.getFormaPagamento().equals((Object)FormaDePagamento.PIX)) {
                template.append("\ud83c\udfe6 *Pagamento em PIX*\n");
            }
        }
    }

    private void renderPromotionBaskets(Pedido order, StringBuilder template) {
        order.getCestasDePromocao().forEach(basket -> basket.getItens().forEach(item -> {
            if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                item.getProdutoComposto().getProdutos().forEach(product -> {
                    int size = item.getProdutoComposto().getProdutos().size();
                    template.append(String.format("\u2705 1/%s %s%n", size, product.getNome()));
                });
            } else {
                template.append(String.format("\u2705 %s%n", item.getProduto().getNome()));
            }
            item.getGrupoPersonalizacoesDeProduto().forEach(group -> {
                template.append(String.format("  \ud83d\udc49 %s %n", ((PersonalizacaoDeProduto)group.getPersonalizacao()).getDescricao()));
                group.getOpcionais().forEach(optional -> template.append(String.format("    %sx %s%n", optional.getQuantidade(), optional.getDescricao())));
            });
            item.getGrupoPersonalizacoes().forEach(group -> {
                template.append(String.format("  \ud83d\udc49 %s %n", ((Personalizacao)group.getPersonalizacao()).getDescricao()));
                group.getOpcionais().forEach(optional -> template.append(String.format("    %sx %s%n", optional.getQuantidade(), optional.getDescricao())));
            });
        }));
    }

    private void sendToMessenger(MensagemDto message) {
        RestTemplate httpRest = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        httpRest.postForEntity(Domains.PedidoAgoraMessenger.POST__SEND_MESSAGE, (Object)new HttpEntity((Object)message), MensagemDto.class, new Object[0]);
    }
}

