/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.HorarioDeFuncionamento;
import com.escolpi.omni.api.model.specification.builder.HorarioDeFuncionamentoSpecificationBuilder;
import com.escolpi.omni.api.repository.HorarioDeFuncionamentoRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HorarioDeFuncionamentoService
implements BaseCrudService<HorarioDeFuncionamento, Long> {
    static final Logger LOGGER = LoggerFactory.getLogger(HorarioDeFuncionamentoService.class);
    @Autowired
    private HorarioDeFuncionamentoRepository horarioDeFuncionamentoRepository;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            this.horarioDeFuncionamentoRepository.deleteById((Object)id);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            throw new ApiException("msg.erro.048", new String[]{"Hor\u00e1rio de Funcionamento", "Empresa"});
        }
    }

    @Transactional
    public void openOrCloseShop(Long empresaId, Boolean abrir) throws ApiException {
        List horarios = this.findAll(empresaId);
        horarios.forEach(horario -> horario.setAbreNoDia(abrir));
        this.horarioDeFuncionamentoRepository.saveAll((Iterable)horarios);
    }

    public Page<HorarioDeFuncionamento> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        HorarioDeFuncionamentoSpecificationBuilder builder = new HorarioDeFuncionamentoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("diaDaSemana", "horaAbertura", "abreNoDia"), (String)"asc");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.horarioDeFuncionamentoRepository.findAll(spec, (Pageable)pageable);
    }

    public List<HorarioDeFuncionamento> findAll(Long empresaId) throws ApiException {
        return this.horarioDeFuncionamentoRepository.findByEmpresaId(empresaId);
    }

    public HorarioDeFuncionamento findById(Long id) throws ApiException {
        return (HorarioDeFuncionamento)this.horarioDeFuncionamentoRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Hor\u00e1rio de Funcionamento", id.toString()}));
    }

    public HorarioDeFuncionamento findById(Long id, Long empresaId) throws ApiException {
        HorarioDeFuncionamento hour = (HorarioDeFuncionamento)this.horarioDeFuncionamentoRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Hor\u00e1rio de Funcionamento", id.toString()}));
        if (!hour.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculado", new String[]{Entidade.HORARIO_DE_FUNCIONAMENTO.getDescricao()});
        }
        return hour;
    }

    @Transactional
    public void save(HorarioDeFuncionamento entity) throws ApiException {
        this.validate(entity);
        if (NullUtil.isNotNullOrZero((Number)entity.getId())) {
            HorarioDeFuncionamento edicao = this.findById(entity.getId());
            edicao.setAbreNoDia(entity.getAbreNoDia());
            edicao.setDiaDaSemana(entity.getDiaDaSemana());
            edicao.setEmpresa(entity.getEmpresa());
            edicao.setHoraAbertura(entity.getHoraAbertura());
            edicao.setHoraFechamento(entity.getHoraFechamento());
            this.horarioDeFuncionamentoRepository.save((Object)edicao);
        } else {
            this.horarioDeFuncionamentoRepository.save((Object)entity);
        }
    }

    public void validate(HorarioDeFuncionamento entity) throws ApiException {
        if (NullUtil.isNull((Object)entity.getDiaDaSemana())) {
            throw new ApiException("msg.erro.001", new String[]{"Dia da Semana"});
        }
        if (NullUtil.isNull((Object)entity.getHoraAbertura())) {
            throw new ApiException("msg.erro.001", new String[]{"Hora de abertura"});
        }
        if (NullUtil.isNull((Object)entity.getHoraFechamento())) {
            throw new ApiException("msg.erro.001", new String[]{"Hora de fechamento"});
        }
        if (entity.getHoraFechamento().before(entity.getHoraAbertura())) {
            throw new ApiException("msg.erro.051");
        }
        if (NullUtil.isNull((Object)entity.getAbreNoDia())) {
            throw new ApiException("msg.erro.001", new String[]{"Abre no dia"});
        }
        if (NullUtil.isNotNullOrZero((Number)entity.getId())) {
            if (this.horarioDeFuncionamentoRepository.countByEmpresaIdAndDiaDaSemanaAndHoraAberturaAndHoraFechamentoAndIdNot(entity.getEmpresa().getId(), entity.getDiaDaSemana(), entity.getHoraAbertura(), entity.getHoraFechamento(), entity.getId()) == 1L) {
                throw new ApiException("erro.entidade.existente.m", new String[]{"Hor\u00e1rio de Funcionamento"});
            }
            if (this.horarioDeFuncionamentoRepository.countByEmpresaIdAndDiaDaSemanaAndHoraAberturaIn(entity.getEmpresa().getId(), entity.getDiaDaSemana(), entity.getHoraAbertura(), entity.getId()) > 0L) {
                throw new ApiException("msg.erro.055", new String[]{"Hora de Abertura"});
            }
            if (this.horarioDeFuncionamentoRepository.countByEmpresaIdAndDiaDaSemanaAndHoraFechamentoIn(entity.getEmpresa().getId(), entity.getDiaDaSemana(), entity.getHoraFechamento(), entity.getId()) > 0L) {
                throw new ApiException("msg.erro.055", new String[]{"Hora de Fechamento"});
            }
        } else {
            if (this.horarioDeFuncionamentoRepository.countByEmpresaIdAndDiaDaSemanaAndHoraAberturaAndHoraFechamento(entity.getEmpresa().getId(), entity.getDiaDaSemana(), entity.getHoraAbertura(), entity.getHoraFechamento()) == 1L) {
                throw new ApiException("erro.entidade.existente.m", new String[]{"Hor\u00e1rio de Funcionamento"});
            }
            if (this.horarioDeFuncionamentoRepository.countByEmpresaIdAndDiaDaSemanaAndHoraAberturaIn(entity.getEmpresa().getId(), entity.getDiaDaSemana(), entity.getHoraAbertura()) > 0L) {
                throw new ApiException("msg.erro.055", new String[]{"Hora de Abertura"});
            }
            if (this.horarioDeFuncionamentoRepository.countByEmpresaIdAndDiaDaSemanaAndHoraFechamentoIn(entity.getEmpresa().getId(), entity.getDiaDaSemana(), entity.getHoraFechamento()) > 0L) {
                throw new ApiException("msg.erro.055", new String[]{"Hora de Fechamento"});
            }
        }
    }
}

